<?php

namespace backend\modules\admin\controllers;

use Yii;

use backend\models\db\Appointment;
use backend\models\db\AppointmentUser;

use yii\filters\AccessControl;
use backend\components\CustomController;


class AppointmentsController extends CustomController
{

    public $enableCsrfValidation = false;


    public function behaviors() {

        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => [
                            'overview'
                        ],
                        'allow' => true,
                        'roles' => ['superadmin'],
                    ],
                ],
            ]
        ];

    }


    public function actionOverview() {

        // get booked appointments
        $bookedAppointments = Appointment::find()
            ->joinWith('appointmentUser')
            ->with('user')
            ->with('appointmentUser.user')
            ->where([
                'and',
                ['NOT', [AppointmentUser::tableName() . '.user_id' => null]],
                ['>=', 'DATE(datetime)', date('Y-m-1')]
            ])
            ->orderBy('datetime asc')
            ->all();

        $this->view->title = "Session Bookings Overview";

        return $this->render('overview', [
            'bookedAppointments' => isset($bookedAppointments) ? $bookedAppointments : []
        ]);

    }

}
