<?php

namespace backend\modules\admin\controllers;

use Yii;

use backend\components\helpers\JsonTools;
use backend\models\db\Bugs;
use backend\modules\admin\models\search\BugsSearch;
use backend\components\CustomController;
use yii\web\HttpException;
use yii\helpers\Url;
use yii\filters\AccessControl;
use dmstr\bootstrap\Tabs;

/**
 * BugsController implements the CRUD actions for Bugs model.
 */
class BugsController extends CustomController
{

    public $enableCsrfValidation = false;


    public function behaviors() {

        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => [
                            'index',
                            'view',
                            'create',
                            'update',
                            'archive'
                        ],
                        'allow' => true,
                        'roles' => ['superadmin'],
                    ],
                ],
            ]
        ];

    }


    /**
     * Lists all Bugs models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel  = new BugsSearch;
        $dataProvider = $searchModel->search($_GET);

        Tabs::clearLocalStorage();

        Url::remember();
        \Yii::$app->session['__crudReturnUrl'] = null;

        $this->view->title = 'Bugs';

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'searchModel' => $searchModel,
        ]);
    }

    /**
     * Displays a single Bugs model.
     * @param integer $id
 *
     * @return mixed
     */
    public function actionView($id)
    {
        \Yii::$app->session['__crudReturnUrl'] = Url::previous();
        Url::remember();
        Tabs::rememberActiveState();

        $this->view->title = 'Bug detail';

        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Bugs model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Bugs;

        try {
            if ($model->load($_POST) && $model->save()) {
                return $this->redirect(Url::previous());
            } elseif (!\Yii::$app->request->isPost) {
                $model->load($_GET);
            }
        } catch (\Exception $e) {
            $msg = (isset($e->errorInfo[2])) ? $e->errorInfo[2] : $e->getMessage();
            $model->addError('_exception', $msg);
        }
        return $this->render('create', ['model' => $model]);
    }

    /**
     * Updates an existing Bugs model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
            $model = $this->findModel($id);

            if ($model->load($_POST) && $model->save()) {
        return $this->redirect(Url::previous());
            } else {
                    return $this->render('update', [
                            'model' => $model,
                    ]);
            }
    }

    /**
     * Archives an existing Bugs model.
     * If archiving is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionArchive($id)
    {

        $confirm = Yii::$app->getRequest()->getQueryParam('confirm', false);

        if ($confirm) {

            $model = $this->findModel($id);
            $model->archived = 1;
            $model->save();

            echo JsonTools::successMessage('Bug successfully archived.');
            die();

        }
        else {

            $this->view->title = 'Archive Bug';

            return $this->render('archive-bug', [
                'bugId' => $id
            ]);

        }
    }

    /**
     * Finds the Bugs model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Bugs the loaded model
     * @throws HttpException if the model cannot be found
     */
    protected function findModel($id)
    {
            if (($model = Bugs::findOne($id)) !== null) {
                    return $model;
            } else {
                    throw new HttpException(404, 'The requested page does not exist.');
            }
    }

}
