<?php
/**
 * Created by PhpStorm.
 * User: robregonm
 * Date: 19/10/15
 * Time: 09:46 PM
 */

namespace backend\modules\admin\controllers;

use backend\components\helpers\Formatter;
use backend\models\db\UserPlan;
use Yii;

use yii\filters\AccessControl;

use backend\components\CustomController;

use backend\components\helpers\JsonTools;


/**
 * UserPlan controller
 */
class UserPlanController extends CustomController
{

    public $enableCsrfValidation = false;

    public function behaviors()
    {

        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => [
                            'create',
                        ],
                        'allow' => true,
                        'roles' => ['coach', 'superadmin'],
                    ],
                ],
            ]
        ];

    }


    /**
     * Create a new user plan
     */
    public function actionCreate($user_id)
    {

        $model = new UserPlan();
        $model->user_id = $user_id;

        if ($model->load(Yii::$app->request->post())) {
            if (Yii::$app->request->isAjax) {
                // this allows to set correct start date for the invoice
                $model->start_time = Formatter::localDatetimeToUtcDatetime(
                    strtotime($_POST['UserPlan']['start_time'] . ' 00:00:00'),
                    'Y-m-d 00:00:00'
                );

                if ($model->validate()) {
                    $model->save();

                    return JsonTools::successMessage('User Plan successfully created.');
                } else {
                    return JsonTools::formErrorMessage($model);
                }
            }
        } else {

            $this->view->title = 'Add User Plan';

            return $this->render('create', [
                'model' => $model
            ]);

        }

    }

}
