<?php

namespace backend\modules\admin\models\form;

use Yii;
use yii\base\Model;
use backend\models\db\NoteAttachment;
use yii\helpers\ArrayHelper;

/**
 * Add note for client
 */
class AddNote extends Model {

    public $name;
    public $content;
    public $attachment;
    public $note_id = false;

    public function rules() {

        // validate input
        $validationRules = [
            ['name', 'required'],
            ['name', 'string', 'min' => 3],
            ['content', 'string'],
            ['attachment', 'file', 'maxFiles' => 3, 'maxSize' => Yii::$app->params['maxNoteAttachmentFileSize']],
            ['attachment', 'attachmentNamesValid']
        ];

        // sanitize
        $filterRules = [
            [['name'], 'filter', 'filter' => 'strip_tags'],
            [['name'], 'filter', 'filter' => 'trim'],
        ];

        return array_merge($validationRules, $filterRules);

    }


    /**
     * Check whether uploaded file names are unique and valid.
     */
    public function attachmentNamesValid($attribute) {

        if ($this->note_id) {

            $attachments = NoteAttachment::findAll(['note_id' => $this->note_id]);
            $uploadedNames = ArrayHelper::map($attachments, 'id', 'name');

        }
        else {

            $uploadedNames = [];

        }

        foreach ($this->{$attribute} as $a) {

            if (!in_array($a->name, $uploadedNames)) {

                $uploadedNames[] = $a->name;

            }
            else {

                $this->addError($attribute, 'Uploaded file name must be unique for each attachment.');

            }

        }

    }

}
