<?php

namespace backend\modules\admin\models\form;

use Yii;
use yii\base\Model;
use backend\models\db\User;

/**
 * Add a user
 */
class AddUser extends Model {

    public $username;
    public $email;
    public $password;
    public $password_repeat;
    public $user_role_id;
    public $user_parent_id;
    public $coach_id;

    public function rules() {

        // validate input
        $validationRules = [
            ['username', 'required'],
            ['username', 'string', 'min' => 8],
            ['username', 'usernameValid'],
            ['email', 'required'],
            ['email', 'email'],
            ['email', 'emailValid'],
            ['password', 'string', 'min' => 8],
            ['password', 'passwordValid'],
            ['password_repeat', 'required', 'when' => function($model) {

                return strlen($model->password) > 0;

            }, 'whenClient' => 'function() {

                return ($("#adduser-password").val().length > 0);

            }', 'message' => 'Re-type password field and password field don\'t match.'],
            ['password_repeat', 'compare', 'compareAttribute' => 'password'],
            ['user_role_id', 'required'],
            ['user_role_id', 'integer'],
            ['user_parent_id', 'required', 'when' => function($model) {

                return ($model->user_role_id == 4);

            }, 'whenClient' => "function (attribute, value) {

                return $('#admin-add-user-form #adduser-user_role_id').val() == 4;

            }"],
            ['user_parent_id', 'userParentIdValid'],
            ['coach_id', 'required', 'when' => function($model) {

                return ($model->user_role_id == 3);

            }, 'whenClient' => "function (attribute, value) {

                return $('#admin-add-user-form #adduser-user_role_id').val() == 3;

            }"],
            ['coach_id', 'coachIdValid']
        ];

        $filterKeys = array_flip(array_keys($this->getAttributes()));
        $filterKeys = array_flip($filterKeys);

        // sanitize
        $filterRules = [
            [$filterKeys, 'filter', 'filter' => 'strip_tags'],
            [$filterKeys, 'filter', 'filter' => 'trim'],

        ];

        return array_merge($validationRules, $filterRules);
    }


    public function usernameValid($attribute) {

        $otherUser = User::find()
            ->where(['username' => $this->$attribute])
            ->andWhere(['!=', 'id', self::getCurrentUserId()])
            ->one();

        if ($otherUser) {
            $this->addError($attribute, 'This username is already taken by another user.');
        }

    }


    public function emailValid($attribute, $p2) {

        $otherUser = User::find()
            ->where(['email' => $this->$attribute])
            ->andWhere(['!=', 'id', self::getCurrentUserId()])
            ->one();

        if ($otherUser) {
            $this->addError($attribute, 'This email is already taken by another user.');
        }

    }


    /**
     * Check whether password is correctly formated.
     * @param string $attribute
     */
    public function passwordValid($attribute) {

        $valid = true;

        // check if there's an uppercase character
        if (strtolower($this->$attribute) === $this->$attribute) {

            $valid = false;

        }

        // check if there's a numeric value in the string
        if (preg_match("/[0-9]+/", $this->$attribute) < 1) {

            $valid = false;

        }

        if (!$valid) {

            $this->addError($attribute, 'The password needs to contain 1 number and 1 uppercase character.');

        }
    }


    public function userParentIdValid($attribute) {

        $user = User::findOne($this->user_parent_id);

        if (!$user) {

            $this->addError($attribute, 'Invalid parent selected.');

        }
        else {

            if (($this->user_role_id == 4) && ($user->user_role_id != 3)) {

                $this->addError($attribute, 'Invalid parent selected.');

            }

            if (($user->user_role_id == 3) && ($user->getUserChildren()->count() == 4)) {

                $this->addError($attribute, 'Can\'t add any more sub-clients to this client.');

            }

        }

    }


    public function coachIdValid($attribute) {

        $user = User::findOne(['id' => $this->coach_id, 'user_role_id' => 2]);

        if (!$user) {

            $this->addError($attribute, 'Invalid parent selected.');

        }

    }


    public static function getCurrentUserId() {

        $urlUserId = Yii::$app->getRequest()->getQueryParam('id', false);

        if ($urlUserId && Yii::$app->user->can('addSubClient')){
            $userId = $urlUserId;
        }
        else {
            $userId = Yii::$app->user->identity->id;
        }

        return $userId;
    }

}
