<?php

namespace backend\modules\admin\models\search;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\db\Bugs;

/**
 * BugsSearch represents the model behind the search form about `backend\models\db\Bugs`.
 */
class BugsSearch extends Bugs {

    /**
     * @inheritdoc
     */
    public function rules() {

        return [
            [['id', 'user_id', 'archived'], 'integer'],
            [['content', 'time', 'url'], 'safe'],
        ];

    }

    /**
     * @inheritdoc
     */
    public function scenarios() {

        // bypass scenarios() implementation in the parent class
        return Model::scenarios();

    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {

        $query = Bugs::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
// uncomment the following line if you do not want to any records when validation fails
// $query->where('0=1');
            return $dataProvider;

        }

        $query->andFilterWhere([
            'id' => $this->id,
            'user_id' => $this->user_id,
            'time' => $this->time,
            'archived' => $this->archived,
        ]);

        $query->andFilterWhere(['like', 'content', $this->content])
                ->andFilterWhere(['like', 'url', $this->url]);

        return $dataProvider;

    }

}
