<?php

namespace backend\modules\admin\models\search;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\db\FaqQuestion;

/**
* FaqQuestionSearch represents the model behind the search form about `backend\models\db\FaqQuestion`.
*/
class FaqQuestionSearch extends FaqQuestion
{
/**
* @inheritdoc
*/
public function rules()
{
return [
[['id', 'faq_category_id', 'archived'], 'integer'],
            [['title', 'description'], 'safe'],
];
}

/**
* @inheritdoc
*/
public function scenarios()
{
// bypass scenarios() implementation in the parent class
return Model::scenarios();
}

/**
* Creates data provider instance with search query applied
*
* @param array $params
*
* @return ActiveDataProvider
*/
public function search($params)
{
$query = FaqQuestion::find();

$dataProvider = new ActiveDataProvider([
'query' => $query,
]);

$this->load($params);

if (!$this->validate()) {
// uncomment the following line if you do not want to any records when validation fails
// $query->where('0=1');
return $dataProvider;
}

$query->andFilterWhere([
            'id' => $this->id,
            'faq_category_id' => $this->faq_category_id,
            'archived' => $this->archived,
        ]);

        $query->andFilterWhere(['like', 'title', $this->title])
            ->andFilterWhere(['like', 'description', $this->description]);

return $dataProvider;
}
}
