<?php

namespace backend\modules\admin\models\search;

use backend\components\helpers\Formatter;
use backend\models\db\UserPlan;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\db\User;
use backend\models\db\UserParent;

use yii\helpers\ArrayHelper;

/**
 * UserSearch represents the model behind the search form about `backend\models\db\User`.
 */
class UserSearch extends User {

    public $userPlanType;

    /**
     * @inheritdoc
     */
    public function rules() {
        return [
            [['id', 'user_role_id', 'userPlanType', 'archived'], 'integer'],
            [['username', 'password', 'password_salt', 'email', 'auth_key', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();

    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params, $userRoleIds = false, $coachId = false) {

        $query = User::find()
            ->select(User::tableName() . '.*');

        if ($coachId) {

            // get main users assigned to coach
            $mainUsers = User::find()
                ->leftJoin(UserParent::tableName(), UserParent::tableName() . '.user_id = ' . User::tableName() . '.id')
                ->where([UserParent::tableName() . '.user_parent_id' => $coachId])
                ->all();

            $mainUserIds = ArrayHelper::map($mainUsers, 'id', 'id');

            $query->leftJoin(UserParent::tableName(), UserParent::tableName() . '.user_id = ' . User::tableName() . '.id')
                ->andWhere([
                    'OR',
                    ['IN', User::tableName() . '.id', $mainUserIds],
                    ['IN', UserParent::tableName() . '.user_parent_id',$mainUserIds]
                ]);

        }

        if ($userRoleIds) {

            $query->andWhere(['IN', 'user_role_id', $userRoleIds]);

        }

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort' => [
                'defaultOrder' => ['created_at' => SORT_ASC]
            ]
        ]);

        $this->load($params);

        if (!$this->validate()) {

            return $dataProvider;

        }

        if ($this->userPlanType) {

            $query->leftJoin(UserPlan::tableName(), UserPlan::tableName() . '.user_id = ' . User::tableName() . '.id')
                ->andWhere([
                    'AND',
                    ['<=', UserPlan::tableName() . '.start_time', Formatter::localDatetimeToUtcDatetime(time(), 'Y-m-d H:i:s')],
                    [UserPlan::tableName() . '.user_plan_type_id' => $this->userPlanType]
                ]);

        }

        $query->andFilterWhere([
            'id' => $this->id,
            'user_role_id' => $this->user_role_id,
            'updated_at' => $this->updated_at,
            'archived' => $this->archived,
        ]);

        $query->andFilterWhere(['like', 'username', $this->username])
            ->andFilterWhere(['like', 'password', $this->password])
            ->andFilterWhere(['like', 'password_salt', $this->password_salt])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'auth_key', $this->auth_key])
            ->andFilterWhere(['like', 'created_at', $this->created_at ? date('Y-m-d', strtotime($this->created_at)) : $this->created_at]);

        return $dataProvider;

    }

}
