<?php

use dmstr\helpers\Html;
use yii\helpers\Url;
use yii\grid\GridView;
use yii\widgets\DetailView;
use yii\widgets\Pjax;
use dmstr\bootstrap\Tabs;
use backend\widgets\FormattedTitle;

?>
<div id="body" class="container-fluid" data-select-menu="li#admin-bugs" data-page-title="<?= FormattedTitle::widget( [ 'title' => $this->title ] ); ?>">
    <div class="row">
        <div class="col-md-12 bugs-view">

            <!-- menu buttons -->
            <p class='pull-left'>
                <?php /* Html::a('<span class="glyphicon glyphicon-pencil"></span> ' . 'Edit',
                    ['update', 'id' => $model->id],
                    ['class' => 'btn btn-info']) ?>
                <?= Html::a('<span class="glyphicon glyphicon-plus"></span> ' . 'New', ['create'],
                    ['class' => 'btn btn-success']) ?>
            </p>

            <p class="pull-right">
                <?= Html::a('<span class="glyphicon glyphicon-list"></span> ' . 'List Bugs', ['index'],
                    ['class' => 'btn btn-default'])*/ ?>
            </p>

            <div class="clearfix"></div>

            <!-- flash message -->
            <?php if (\Yii::$app->session->getFlash('deleteError') !== null) : ?>
                <span class="alert alert-info alert-dismissible" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span></button>
                    <?= \Yii::$app->session->getFlash('deleteError') ?>
        </span>
            <?php endif; ?>

            <div class="panel panel-default">
                <div class="panel-body">


                    <?php $this->beginBlock('backend\models\db\Bugs'); ?>

                    <?= DetailView::widget([
                        'model' => $model,
                        'attributes' => [
                            'id',
// generated by schmunk42\giiant\generators\crud\providers\RelationProvider::attributeFormat
                            [
                                'format' => 'html',
                                'attribute' => 'user_id',
                                'value' => ($model->user ? Html::a($model->user->username, [
                                    'user/view',
                                    'id' => $model->user->id,
                                ]) : '<span class="label label-warning">?</span>'),
                            ],
                            'content:ntext',
                            'time',
                            'url:url',
                            'archived:boolean',
                        ],
                    ]); ?>

                    <hr/>

                    <?= Html::a('Archive',
                        ['archive', 'id' => $model->id],
                        [
                            'class' => 'btn btn-danger open-modal',
                            'data-modal-url' => Url::toRoute(['/admin/bugs/archive', 'id' => $model->id])
                        ]); ?>
                    <?php $this->endBlock(); ?>



                    <?= Tabs::widget(
                        [
                            'id' => 'relation-tabs',
                            'encodeLabels' => false,
                            'items' => [
                                [
                                    'label' => '<b class=""># ' . $model->id . '</b>',
                                    'content' => $this->blocks['backend\models\db\Bugs'],
                                    'active' => true,
                                ],
                            ]
                        ]
                    );
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?= \backend\components\helpers\JsTools::viewJs($this); ?>
