<?php
use backend\components\helpers\Calculator;
use backend\components\helpers\Formatter;
use dosamigos\datetimepicker\DateTimePicker;
use dosamigos\typeahead\TypeAhead;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>

<?php $form = ActiveForm::begin([
    'id' => 'add-time-slot-form',
    'options' => [
        'data-summary-url' => Url::to(['/admin/coach/summary'])
    ]
]); ?>
<div class="modal-body">

    <div class="message"></div>

    <div class="row">
        <div class="col-md-12">
            <?= $form->field($formModel, 'name')
                ->label('Name (optional)') ?>
        </div>
        <div class="col-md-6">
            <?= $form->field($formModel, 'formattedStartDate')->widget(DateTimePicker::className(), [
                'template' => '{input}{button}',
                'pickButtonIcon' => 'glyphicon glyphicon-calendar',
                'clientOptions' => [
                    'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
                    'minView' => 'month',
                    'maxView' => 'year',
                    'autoclose' => true
                ]
            ])->label('Start Date/Time') ?>
        </div>
        <div class="col-md-6">
            <?= $form->field($formModel, 'startTime')
                ->dropDownList(Calculator::getTimeOfDayHours())
                ->label('&nbsp;')
            /*$form->field($formModel, 'startTime')->widget(TypeAhead::className(), [
                'options' => ['class' => 'form-control'],
                'engines' => [ $engine ],
                'clientOptions' => [
                    'highlight' => true,
                    'minLength' => 1,
                ],
                'dataSets' => [
                    [
                        'name' => 'startTime',
                        'displayKey' => 'value',
                        'source' => $engine->getAdapterScript()
                    ]
                ]
            ])->label('&nbsp;')*/ ?>
        </div>
        <div class="col-md-6">
            <?= $form->field($formModel, 'formattedEndDate')->widget(DateTimePicker::className(), [
                'template' => '{input}{button}',
                'pickButtonIcon' => 'glyphicon glyphicon-calendar',
                'clientOptions' => [
                    'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
                    'minView' => 'month',
                    'maxView' => 'year',
                    'autoclose' => true
                ]
            ])->label('End Date/Time') ?>
        </div>
        <div class="col-md-6">
            <?= $form->field($formModel, 'endTime')
                ->dropDownList(Calculator::getTimeOfDayHours())
                ->label('&nbsp;') ?>
        </div>
        <?php /*<div class="col-md-12">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Slot Type</label>
                        <?= $form->field($formModel, 'slotType')->radio([
                            'template' => '<div class="radio">{input} {label}</div>',
                            'value' => AddTimeSlot::SINGLE_APPOINTMENT
                        ])->label('Single Appointment Slot') ?>
                    </div>
                </div>
                <div class="col-md-3">
                    <label>&nbsp;</label>
                    <?= $form->field($formModel, 'slotType')->radio([
                        'template' => '<div class="radio">{input} {label}</div>',
                        'value' => AddTimeSlot::SLOT_MINUTES
                    ])->label('Slots of length:') ?>
                </div>
                <div class="col-md-3">
                    <label>&nbsp;</label>
                    <?= $form->field($formModel, 'slotLength', [
                        'inputTemplate' => '<div class="input-group">{input}<span class="input-group-addon">mins</span></div>'
                    ])->label(false) ?>
                </div>
            </div>
        </div>*/ ?>
        <div class="col-md-12">
            <?= $form->field($formModel, 'repeat')->checkbox(['template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"])->label('Repeat') ?>
        </div>
        <div class="col-md-12" id="addtimeslot-repeat-box" <?= !$formModel->repeat ? 'style="display:none"' : '' ?>>
            <div class="row">
                <div class="col-md-3">
                    <?= $form->field($formModel, 'frequency')->dropDownList($frequencies) ?>
                </div>
                <div class="col-md-3">
                    <?= $form->field($formModel, 'repeatEvery', [
                        'inputTemplate' => '<div class="input-group">{input}<span class="input-group-addon">days</span></div>'
                    ]) ?>
                </div>
                <div class="col-md-6">
                    <?= $form->field($formModel, 'formattedRepeatUntilDate')->widget(DateTimePicker::className(), [
                        'template' => '{input}{button}',
                        'pickButtonIcon' => 'glyphicon glyphicon-calendar',
                        'clientOptions' => [
                            'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
                            'minView' => 'month',
                            'maxView' => 'year',
                            'autoclose' => true
                        ]
                    ])->label('Repeat Until Date') ?>
                </div>
            </div>
        </div>
        <hr/>
        <div class="col-md-12">
            <div class="panel panel-info">
                <div class="panel-heading">
                    <span id="summary-text"><?= $formModel->getTextSummary($timezone) ?></span>
                </div>
            </div>
        </div>
    </div>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?php if ($edit) {
        echo Html::submitButton('Delete Time-slot', [
            'class' => 'btn btn-danger open-modal',
            'data-modal-url' => Url::toRoute(['/admin/coach/delete-time-slot', 'id' => $edit])
        ]);
        echo Html::submitButton('Edit Time-slot', [
            'class' => 'btn btn-primary ajax-submit',
            'data-js-callback' => 'reloadAppointmentsDay',
            'data-submit-url' => Url::toRoute(['/admin/coach/add-time-slot', 'id' => $edit])
        ]);
    } else {
        echo Html::submitButton('Add Time-slot', [
            'class' => 'btn btn-primary ajax-submit',
            'data-js-callback' => 'reloadAppointmentsDay',
            'data-submit-url' => Url::toRoute('/admin/coach/add-time-slot')
        ]);
    } ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>


