<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;

$timeSlotUrl = Url::toRoute(['/admin/coach/add-time-slot']);

?>
<div id="body" class="container-fluid" data-js-callback="messagingLoaded" data-select-menu="li#admin-appointments" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">

    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3><?= Html::encode($this->title) ?></h3>
                <a href="#" class="btn btn-primary btn-sm open-modal pull-right" data-modal-url="<?= Url::toRoute(['/admin/coach/add-appointment']) ?>">Add Appointment</a>
            </div>
        </div>
    </div>

    <div class="row mb20 appointments">
        <div class="col-md-7">
            <div class="col-head mb10">
                <h4>Availability Time Slots</h4>
            </div>
            <?= yii2fullcalendar\yii2fullcalendar::widget([
                'id' => 'slots-calendar',
                'header' => [
                    'left' => 'prev,next today',
                    'center' => 'title',
                    'right' => 'month,agendaWeek,agendaDay'
                ],
                'select' => new \yii\web\JsExpression("function(start, end) { openModal('{$timeSlotUrl}?start=' + start + '&end=' + end); }"),
                'eventClick' => new \yii\web\JsExpression("function(event, jsEvent, view) { openModal('{$timeSlotUrl}?id=' + event.id + '&type=' + event.type); }"),
                'ajaxEvents' => Url::to(['/admin/coach/events']),
                'clientOptions' => [
                    'selectable' => true
                ]
            ]); ?>
        </div>
        <div class="col-md-5">
            <div class="col-head mb10">
                <h4>Appointments</h4>
            </div>
            <?= yii2fullcalendar\yii2fullcalendar::widget([
                'id' => 'slots-summary',
                'header' => [
                    'left' => 'prev,next today',
                    'right' => 'title',
                    //'right' => 'month,agendaWeek,agendaDay,listWeek'
                ],
                'defaultView' => 'listWeek',
                'ajaxEvents' => Url::to(['/admin/coach/bookings'])
            ]); ?>
        </div>
    </div>

</div>
<?= \backend\components\helpers\JsTools::viewJs($this) ?>
