<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;
?>

<div id="body" class="container-fluid secondary-nav" data-js-callback="messagingLoaded" data-select-menu="li#admin-conversations" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">

    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3><?= Html::encode($this->title) ?></h3>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12" id="conversations">
            <ul class="messages-list">
                <?php foreach ($messages as $message) {
                    /** @var User $user */
                    $user = $messagesData['participants'][$message->user_id]; ?>
                    <li class="<?= $message->user_id == $userId ? 'mine' : 'their' ?>" data-message-id="<?= $message->id ?>">
                        <img class="avatar" src="<?= $user->getAvatarUrl() ?>">
                        <div class="message-part">
                            <span class="name"><?= $user->getFullName(true) ?></span>
                            <span class="date"><?= Formatter::datetime(Formatter::utcDatetimeToLocalDatetime($message->time, $timezone->code, 'Y-m-d H:i:s')) ?></span>
                            <p class="message"><?= $message->text ?></p>
                            <div class="clear"></div>
                        </div>
                    </li>
                <?php } ?>
            </ul>
            <textarea id="new-message" name="messages-input" class="messages-input conversations-page" placeholder="Enter message here..." data-conversation-id="<?= $conversation->id ?>"></textarea>
            <a href="#" class="btn btn-success send-message">Send</a>
        </div>
    </div>
</div>
<?= \backend\components\helpers\JsTools::viewJs($this) ?>
