<?php
use backend\models\db\User;
use yii\db\Query;
use yii\helpers\Url;
use backend\models\db\UserMeta;
use backend\models\db\UserPlan;
use backend\models\db\UserPlanType;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;

?>

<div id="body" class="container-fluid" data-select-menu="li#admin-dashboard" data-js-callback="bodyLoaded" data-page-title="<?= FormattedTitle::widget( [ 'title' => $this->title ] ); ?>">
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3 style="display:block">
                    Admin's Dashboard
                    <small class="pull-right"><a href="<?= Url::to(['/admin/default/admin-dashboard', 'force' => 1]) ?>">refresh now</a></small>
                </h3>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-0">
                    Users per Plan
                    <a href="#" class="pull-right open-modal" data-modal-url="<?= Url::to(['/admin/default/upp-chart']) ?>" data-with-graph="1">
                        <strong>show chart</strong>
                    </a>
                </div>
                <ul class="list-group">
                    <li class="list-group-item">
                        <span class="title">Overview</span>
                        <ul>
                            <li>
                                <span class="badge pull-right"><?= $allActivePlansCount ?></span>
                                All Active Clients
                            </li>
                            <li>
                                <span class="badge pull-right"><?= '$' . number_format($allActivePlansIncome, 2); ?></span>
                                Total Monthly Income
                            </li>
                        </ul>
                    </li>
                    <?php foreach ($planCounts as $planName => $stats) { ?>
                    <li class="list-group-item">
                        <span class="badge"><?= $stats['total'] ?></span>
                        <span class="title"><?= $planName ?></span>
                        <ul>
                            <li>
                                <span class="badge pull-right"><?= $stats['thisMonthSub'] ?></span>
                                This month subscriptions
                            </li>
                            <li>
                                <span class="badge pull-right"><?= $stats['prevMonthSub'] ?></span>
                                Previous month subscriptions
                            </li>
                            <!--<li>
                                <span class="badge pull-right">-</span>
                                Last 30 days unsubscriptions
                            </li>
                            <li>
                                <span class="badge pull-right">-</span>
                                Previous month unsubscriptions
                            </li>-->
                            <li>
                                <span class="badge pull-right"><?= ($stats['income']) ? '$' . number_format($stats['income'], 2) : '-'; ?></span>
                                <span class="title">Monthly Income</span>
                            </li>
                        </ul>
                    </li>
                    <?php } ?>
                </ul>
            </div>
        </div>

        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard" id="new-users-box">
                <div class="panel-heading color-8">
                    New Users
                    <select class="pull-right" id="new-users-months">
                        <option value="1" selected>1 month</option>
                        <option value="6">6 months</option>
                        <option value="12">1 year</option>
                    </select>
                </div>
                <div class="dynamic-content" id="new-users-content" data-ajax="<?= Url::to(['/admin/default/new-users']) ?>" data-ajax-base="<?= Url::to(['/admin/default/new-users']) ?>"></div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-7">Coaches</div>
                <ul class="list-group">
                    <li class="list-group-item">
                        <span class="badge"><?= $coachesCount ?></span>
                        Coaches Total
                    </li>
                    <?php foreach ($coachPlanBreakdown as $coachId => $data) { ?>
                    <?php if (isset($coaches[$coachId])) { ?>
                    <li class="list-group-item">
                        <span class="title"><?= $coaches[$coachId]->getFullName(true) ?></span>
                        <ul>
                            <li>
                                <span class="badge pull-right"><?= isset($coachUserCount30Days[$coachId]) ? $coachUserCount30Days[$coachId] : 0 ?></span>
                                Last 30 Days Plans
                            </li>
                            <li>
                                <span class="badge pull-right"><?= isset($coachUserCount12Months[$coachId]) ? $coachUserCount12Months[$coachId] : 0 ?></span>
                                Last 12 Months Plans
                            </li>
                            <?php if (!empty($data['plans']) && is_array($data['plans'])) {
                                foreach ($data['plans'] as $plan => $total) { ?>
                            <li>
                                <span class="badge pull-right"><?= $total ?></span>
                                <?= $plan ?>
                            </li>
                                <?php }
                            } ?>
                            <li>
                                <span class="badge pull-right"><?= $data['inactive_users'] ?></span>
                                Expired Plans
                            </li>
                            <li>
                                <span class="badge pull-right"><?= '$' . number_format($data['income'], 2); ?></span>
                                <span class="title">Monthly Income</span>
                            </li>
                        </ul>
                    </li>
                    <?php } ?>
                    <?php } ?>
                </ul>
            </div>
        </div>
        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-1">
                    EoMS (<?= date('M Y', strtotime('-1 month', strtotime(date('Y-m-20')))) ?>)
                    <a href="#" class="pull-right open-modal" data-modal-url="<?= Url::to(['/admin/default/eoms-users']) ?>">
                        <strong>show users</strong>
                    </a>
                </div>
                <ul class="list-group">
                    <li class="list-group-item">
                        <span class="badge"><?= $eomsCompletedCount ?> / <?= $eomsTotalCount ?></span>
                        <span class="title">Total Completed</span>
                        <ul>
                            <li>
                                <span class="badge pull-right"><?= $eomsPositiveCount ?></span>
                                Surplus Count
                            </li>
                            <?php if (!empty($eomsPositiveAmount)) { ?>
                            <li>
                                Total Surplus Amount
                                <ul>
                                    <?php foreach ($eomsPositiveAmount as $currency => $amount) { ?>
                                    <li>
                                        <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                        <?= $currency ?>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </li>
                            <li>
                                Average Surplus Amount
                                <ul>
                                    <?php foreach ($eomsAvgPositiveAmount as $currency => $amount) { ?>
                                    <li>
                                        <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                        <?= $currency ?>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </li>
                            <?php } ?>
                            <li>
                                <span class="badge pull-right"><?= $eomsNegativeCount ?></span>
                                Deficit Count
                            </li>
                            <?php if (!empty($eomsNegativeAmount)) { ?>
                            <li>
                                Total Deficit Amount
                                <ul>
                                    <?php foreach ($eomsNegativeAmount as $currency => $amount) { ?>
                                    <li>
                                        <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                        <?= $currency ?>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </li>
                            <li>
                                Average Deficit Amount
                                <ul>
                                    <?php foreach ($eomsAvgNegativeAmount as $currency => $amount) { ?>
                                    <li>
                                        <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                        <?= $currency ?>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </li>
                            <?php } ?>
                        </ul>
                    </li>
                    <?php foreach ($coachEoms as $coachId => $data) { ?>
                    <?php if (isset($coaches[$coachId])) { ?>
                    <li class="list-group-item">
                        <span class="title"><?= $coaches[$coachId]->getFullName(true) ?></span>
                        <ul>
                            <li>
                                <span class="badge pull-right"><?= $data['eomsCompletedCount'] ?> / <?= $data['eomsTotalCount'] ?></span>
                                Total Completed
                            </li>
                            <li>
                                <span class="badge pull-right"><?= $data['eomsPositiveCount'] ?></span>
                                Surplus Count
                            </li>
                            <?php if (!empty($data['eomsPositiveAmount'])) { ?>
                            <li>
                                Total Surplus Amount
                                <ul>
                                    <?php foreach ($data['eomsPositiveAmount'] as $currency => $amount) { ?>
                                    <li>
                                        <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                        <?= $currency ?>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </li>
                            <li>
                                Average Surplus Amount
                                <ul>
                                    <?php foreach ($data['eomsAvgPositiveAmount'] as $currency => $amount) { ?>
                                    <li>
                                        <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                        <?= $currency ?>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </li>
                            <?php } ?>
                            <li>
                                <span class="badge pull-right"><?= $data['eomsNegativeCount'] ?></span>
                                Deficit Count
                            </li>
                            <?php if (!empty($data['eomsNegativeAmount'])) { ?>
                            <li>
                                Total Deficit Amount
                                <ul>
                                    <?php foreach ($data['eomsNegativeAmount'] as $currency => $amount) { ?>
                                    <li>
                                        <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                        <?= $currency ?>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </li>
                            <li>
                                Average Deficit Amount
                                <ul>
                                    <?php foreach ($data['eomsAvgNegativeAmount'] as $currency => $amount) { ?>
                                    <li>
                                        <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                        <?= $currency ?>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </li>
                            <?php } ?>
                        </ul>
                    </li>
                    <?php } ?>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-2">Debts</div>
                <ul class="list-group">
                    <li class="list-group-item">
                        <?php if (empty($debtPaymentsTotalAmounts)) { ?>
                            <span class="badge pull-right">-</span>
                        <?php } ?>
                        <span class="title">Total Debt Paid Off</span>
                        <ul>
                            <?php foreach ($debtPaymentsTotalAmounts as $currency => $debtData) { ?>
                                <li>
                                    <span class="badge pull-right"><?= Formatter::currency($debtData['total'], 'none') ?></span>
                                    <span class="title"><?= $currency ?></span><br/>
                                    <?php foreach ($debtData as $type => $amount) {
                                        if ($type != 'total') { ?>
                                        <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                        <?= $type ?><br/>
                                        <?php }
                                    } ?>
                                </li>
                            <?php } ?>
                        </ul>
                    </li>
                    <li class="list-group-item">
                        <?php if (empty($debtPayments30DaysAmounts)) { ?>
                        <span class="badge pull-right">-</span>
                        <?php } ?>
                        <span class="title">Last 30 Days Reduction</span>
                        <ul>
                            <?php foreach ($debtPayments30DaysAmounts as $currency => $debtData) { ?>
                            <li>
                                <span class="badge pull-right"><?= Formatter::currency($debtData['total'], 'none') ?></span>
                                <span class="title"><?= $currency ?></span><br/>
                                <?php foreach ($debtData as $type => $amount) {
                                    if ($type != 'total') { ?>
                                    <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                    <?= $type ?><br/>
                                    <?php }
                                } ?>
                            </li>
                            <?php } ?>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-3">Recently active users</div>
                <ul class="list-group">
                    <?php if (!empty($recentlyActiveUsersByCoach)) { ?>
                    <?php foreach ($recentlyActiveUsersByCoach as $coachId => $users) {
                        $coach = User::findOne($coachId); ?>
                    <li class="list-group-item">
                        <?php if (isset($recentLoginPeriods[$coachId])) { ?>
                        <span class="badge pull-right"><?= $recentLoginPeriods[$coachId] ?></span>
                        <?php } ?>
                        <span class="title"><?= $coach->getFullName(true) ?></span>
                        <ul>
                            <?php foreach ($users as $r) { ?>
                            <li>
                                <span class="badge pull-right"><?= $recentLoginPeriods[$r->id] ?></span>
                                <a href="<?= Url::toRoute(['/admin/user/switch', 'id' => $r->id]) ?>"><?= $r->getFullName(true) ?></a>
                            </li>
                            <?php } ?>
                        </ul>
                    </li>
                    <?php } ?>
                    <?php } else { ?>
                    <li class="list-group-item">No recently active users.</li>
                    <?php } ?>
                </ul>
            </div>
        </div>
        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-4">Inactive users</div>
                <ul class="list-group">
                    <?php if (!empty($inactiveUsersByCoach)) { ?>
                    <?php foreach ($inactiveUsersByCoach as $coachId => $users) {
                        $coach = User::findOne($coachId); ?>
                    <li class="list-group-item">
                        <?php if (isset($inactiveUsers[$coachId])) { ?>
                        <span class="badge pull-right"><?= ceil((time() - strtotime($inactiveUsers[$coachId]->login_time)) / 86400) ?> days</span>
                        <?php } ?>
                        <span class="title"><?= $coach->getFullName(true) ?></span>
                        <ul>
                            <?php foreach ($users as $i) { ?>
                            <li>
                                <span class="badge pull-right"><?= $i->seconds_ago ?> days</span>
                                <a href="<?= Url::toRoute(['/admin/user/switch', 'id' => $i->id]) ?>"><?= $i->getFullName(true) ?></a>
                            </li>
                            <?php } ?>
                        </ul>
                    </li>
                    <?php } ?>
                    <?php } else { ?>
                    <li class="list-group-item">No inactive users.</li>
                    <?php } ?>
                </ul>
            </div>
        </div>
        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-5">Overspending users</div>
                <ul class="list-group">
                    <?php if (!empty($overspendingUsersByCoach)) { ?>
                    <?php foreach ($overspendingUsersByCoach as $coach => $users) {
                        $coach = User::findOne($coachId); ?>
                    <li class="list-group-item">
                        <span class="title"><?= $coach->getFullName(true) ?></span>
                        <ul>
                            <?php foreach ($users as $o) { ?>
                            <li>
                                <span class="badge pull-right"><?= Formatter::currency($o['total'], 'none') . ' ' . $userCurrencies[$o['user']->id] ?></span>
                                <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/admin/default/overspending', 'id' => $o['user']->id]) ?>"><?= $o['user']->getFullName(true) ?></a>
                            </li>
                            <?php } ?>
                        </ul>
                    </li>
                    <?php } ?>
                    <?php } else { ?>
                    <li class="list-group-item">No overspending users.</li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-6">Upcoming client birthdays</div>
                <ul class="list-group">
                    <?php if (!empty($userBirthdaysByCoach)) { ?>
                    <?php foreach ($userBirthdaysByCoach as $coachId => $users) {
                        $coach = User::findOne($coachId); ?>
                    <li class="list-group-item">
                        <span class="title"><?= $coach ? $coach->getFullName(true) : 'N/A' ?></span>
                        <ul>
                            <?php foreach ($users as $b) { ?>
                            <li>
                                <span class="badge pull-right"><?= Formatter::date($b->value) ?></span>
                                <?php if ($b->user->user_role_id > 4) { ?>
                                <a href="<?= Url::toRoute(['/admin/user/switch', 'id' => $b->user->id]) ?>"><?= $b->user->getFullName(true) ?></a>
                                <?php } else {
                                    echo $b->user->getFullName(true);
                                } ?>
                            </li>
                            <?php } ?>
                        </ul>
                    </li>
                    <?php } ?>
                    <?php } else { ?>
                    <li class="list-group-item">No upcoming birthdays.</li>
                    <?php } ?>
                </ul>
            </div>
        </div>
        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-9">Upcoming coach birthdays</div>
                <ul class="list-group">
                    <?php if (!empty($coachBirthdays)) { ?>
                    <?php foreach ($coachBirthdays as $b) { ?>
                    <li class="list-group-item">
                        <span class="badge pull-right"><?= Formatter::date($b->value) ?></span>
                        <a href="<?= Url::toRoute(['/admin/user/switch', 'id' => $b->user->id]) ?>"><?= $b->user->getFullName(true) ?></a>
                    </li>
                    <?php } ?>
                    <?php } else { ?>
                    <li class="list-group-item">No upcoming birthdays.</li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <h4>Client's Activity Log</h4>
            <div class="panel panel-table">
                <?= $this->render('@backend/views/activity-log/_activity-log-by-coach-table'); ?>
            </div>
        </div>
    </div>

</div>
