<?php
use yii\db\Query;
use yii\helpers\Url;
use backend\models\db\UserMeta;
use backend\models\db\UserPlan;
use backend\models\db\UserPlanType;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;

?>

<div id="body" class="container-fluid" data-select-menu="li#coach-dashboard" data-js-callback="bodyLoaded" data-page-title="<?= FormattedTitle::widget( [ 'title' => $this->title ] ); ?>">
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3 style="display: block">
                    Coach's Dashboard
                    <small class="pull-right"><a href="<?= Url::to(['/admin/default/coach-dashboard', 'force' => 1]) ?>">refresh now</a></small>
                </h3>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-0">
                    Users per Plan
                    <a href="#" class="pull-right open-modal" data-modal-url="<?= Url::to(['/admin/default/upp-chart']) ?>" data-with-graph="1">
                        <strong>show chart</strong>
                    </a>
                </div>
                <ul class="list-group">
                    <li class="list-group-item">
                        <span class="badge pull-right"><?= $usersAssignedOver12Months ?></span>
                        Assigned Over Last 12 Months<br/>
                        <span class="badge"><?= $allActivePlansCount ?></span>
                        All Active Clients
                    </li>
                    <?php foreach ($planCounts as $planName => $stats) { ?>
                    <li class="list-group-item">
                        <span class="badge"><?= $stats['total'] ?></span>
                        <span class="title"><?= $planName ?></span>
                        <ul>
                            <li>
                                <span class="badge pull-right"><?= $stats['thisMonthSub'] ?></span>
                                This month subscriptions
                            </li>
                            <li>
                                <span class="badge pull-right"><?= $stats['prevMonthSub'] ?></span>
                                Previous month subscriptions
                            </li>
                            <!--<li>
                                <span class="badge pull-right">-</span>
                                Last 30 days unsubscriptions
                            </li>
                            <li>
                                <span class="badge pull-right">-</span>
                                Previous month unsubscriptions
                            </li>-->
                        </ul>
                    </li>
                    <?php } ?>
                </ul>
            </div>
        </div>

        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard" id="new-users-box">
                <div class="panel-heading color-8">
                    New Users
                    <select class="pull-right" id="new-users-months">
                        <option value="1" selected>1 month</option>
                        <option value="6">6 months</option>
                        <option value="12">1 year</option>
                    </select>
                </div>
                <div class="dynamic-content" id="new-users-content" data-ajax="<?= Url::to(['/admin/default/new-users']) ?>" data-ajax-base="<?= Url::to(['/admin/default/new-users']) ?>"></div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-1">
                    EoMS (<?= date('M Y', strtotime('-1 month', strtotime(date('Y-m-20')))) ?>)
                    <a href="#" class="pull-right open-modal" data-modal-url="<?= Url::to(['/admin/default/eoms-users']) ?>">
                        <strong>show users</strong>
                    </a>
                </div>
                <ul class="list-group">
                    <li class="list-group-item">
                        <span class="badge"><?= $eomsCompletedCount ?> / <?= $eomsTotalCount ?></span>
                        <span class="title">Completed</span>
                        <ul>
                            <li>
                                <span class="badge pull-right"><?= $eomsPositiveCount ?></span>
                                Surplus Count
                            </li>
                            <?php if (count($eomsPositiveAmount)) { ?>
                            <li>
                                Total Surplus Amount
                                <ul>
                                    <?php foreach ($eomsPositiveAmount as $currency => $amount) { ?>
                                    <li>
                                        <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                        <?= $currency ?>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </li>
                            <li>
                                Average Surplus Amount
                                <ul>
                                    <?php foreach ($eomsAvgPositiveAmount as $currency => $amount) { ?>
                                    <li>
                                        <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                        <?= $currency ?>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </li>
                            <?php } ?>
                            <li>
                                <span class="badge pull-right"><?= $eomsNegativeCount ?></span>
                                Deficit Count
                            </li>
                            <?php if (count($eomsNegativeAmount)) { ?>
                            <li>
                                Total Deficit Amount
                                <ul>
                                    <?php foreach ($eomsNegativeAmount as $currency => $amount) { ?>
                                    <li>
                                        <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                        <?= $currency ?>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </li>
                            <li>
                                Average Deficit Amount
                                <ul>
                                    <?php foreach ($eomsAvgNegativeAmount as $currency => $amount) { ?>
                                    <li>
                                        <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                        <?= $currency ?>
                                    </li>
                                    <?php } ?>
                                </ul>
                            </li>
                            <?php } ?>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>

        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-2">Debts</div>
                <ul class="list-group">
                    <li class="list-group-item">
                        <?php if (empty($debtPaymentsTotalAmounts)) { ?>
                        <span class="badge pull-right">-</span>
                        <?php } ?>
                        <span class="title">Total Debt Paid Off</span>
                        <ul>
                            <?php foreach ($debtPaymentsTotalAmounts as $currency => $debtData) { ?>
                            <li>
                                <span class="badge pull-right"><?= Formatter::currency($debtData['total'], 'none') ?></span>
                                <span class="title"><?= $currency ?></span><br/>
                                <?php foreach ($debtData as $type => $amount) {
                                    if ($type != 'total') { ?>
                                    <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                    <?= $type ?><br/>
                                    <?php }
                                } ?>
                            </li>
                            <?php } ?>
                        </ul>
                    </li>
                    <li class="list-group-item">
                        <?php if (empty($debtPayments30DaysAmounts)) { ?>
                        <span class="badge pull-right">-</span>
                        <?php } ?>
                        <span class="title">Last 30 Days Reduction</span>
                        <ul>
                            <?php foreach ($debtPayments30DaysAmounts as $currency => $debtData) { ?>
                                <li>
                                    <span class="badge pull-right"><?= Formatter::currency($debtData['total'], 'none') ?></span>
                                    <span class="title"><?= $currency ?></span><br/>
                                    <?php foreach ($debtData as $type => $amount) {
                                        if ($type != 'total') { ?>
                                        <span class="badge pull-right"><?= Formatter::currency($amount, 'none') ?></span>
                                        <?= $type ?><br/>
                                        <?php }
                                    } ?>
                                </li>
                            <?php } ?>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-3">Recently active users</div>
                <ul class="list-group">
                    <li class="list-group-item">
                        <?php if (count($recentlyActiveUsers)) { ?>
                        <ul>
                            <?php foreach ($recentlyActiveUsers as $r) { ?>
                            <li>
                                <a href="<?= Url::toRoute(['/admin/user/switch', 'id' => $r->id]) ?>"><?= $r->getFullName(true) ?></a>
                                <span class="pull-right"><?= $recentLoginPeriods[$r->id] ?></span>
                            </li>
                            <?php } ?>
                        </ul>
                        <?php } else { ?>
                        No recently active users.
                        <?php } ?>
                    </li>
                </ul>
            </div>
        </div>

        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-4">Inactive users</div>
                <ul class="list-group">
                    <li class="list-group-item">
                        <?php if (count($inactiveUsers)) { ?>
                        <ul>
                            <?php foreach ($inactiveUsers as $i) { ?>
                            <li>
                                <a href="<?= Url::toRoute(['/admin/user/switch', 'id' => $i->id]) ?>"><?= $i->getFullName(true) ?></a>
                                <span class="pull-right"><?= $i->seconds_ago ?> days</span>
                            </li>
                            <?php } ?>
                        </ul>
                        <?php } else { ?>
                        No inactive users.
                        <?php } ?>
                    </li>
                </ul>
            </div>
        </div>

        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-5">Overspending users</div>
                <ul class="list-group">
                    <li class="list-group-item">
                        <?php if (count($overspendingUsers)) { ?>
                        <ul>
                            <?php foreach ($overspendingUsers as $o) { ?>
                            <li>
                                <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/admin/default/overspending', 'id' => $o['user']->id]) ?>"><?= $o['user']->getFullName(true) ?></a>
                                <span class="badge pull-right"><?= Formatter::currency($o['total'], 'none') . ' ' . $userCurrencies[$o['user']->id] ?></span>
                            </li>
                            <?php } ?>
                        </ul>
                        <?php } else { ?>
                        No overspending users.
                        <?php } ?>
                    </li>
                </ul>
            </div>
        </div>

        <div class="col-md-3">
            <div class="panel panel-default panel-dashboard">
                <div class="panel-heading color-6">Upcoming birthdays</div>
                <ul class="list-group">
                    <li class="list-group-item">
                        <?php if (count($birthdays)) { ?>
                        <ul>
                            <?php foreach ($birthdays as $b) { ?>
                            <li>
                                <?php if ($b->user->user_role_id == 3) { ?>
                                <a href="<?= Url::toRoute(['/admin/user/switch', 'id' => $b->user->id]) ?>"><?= $b->user->getFullName(true) ?></a>
                                <?php } else {
                                    echo $b->user->getFullName(true);
                                } ?>
                                <span class="badge pull-right"><?= Formatter::date($b->value) ?></span>
                            </li>
                            <?php } ?>
                        </ul>
                        <?php } else { ?>
                        No upcoming birthdays.
                        <?php } ?>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <h4>Client's Activity Log</h4>
            <div class="panel panel-table">
                <?= $this->render('@backend/views/activity-log/_activity-log-by-coach-table'); ?>
            </div>
        </div>
    </div>

</div>
