<?php
use backend\components\helpers\Formatter;
use backend\models\db\Debt;
use backend\models\db\Expense;
use yii\helpers\Html;

/** @var Expense $expense */
?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<div class="modal-body">
    <table class="table">
        <thead>
        <tr>
            <th class="text-center">Jar Name</th>
            <th class="text-center">Amount</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($overspendingAmounts['jars'] as $jar) { ?>
        <tr>
            <td><?= $jar['name'] ?></td>
            <td class="text-right"><?= Formatter::currency($jar['balance'], 'none') . ' ' . $currency ?></td>
        </tr>
        <?php } ?>
        </tbody>
        <tfoot>
        <tr>
            <th class="text-right">Total:</th>
            <th class="text-right"><?= Formatter::currency($overspendingAmounts['total'], 'none') . ' ' . $currency ?></th>
        </tr>
        </tfoot>
    </table>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
</div>