<?php

use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use \dmstr\bootstrap\Tabs;

/**
 * @var yii\web\View $this
 * @var backend\models\db\FaqCategory $model
 * @var yii\widgets\ActiveForm $form
 */

?>

<?php $form = ActiveForm::begin([
        'id' => 'FaqCategory',
        'enableClientValidation' => true,
        'errorSummaryCssClass' => 'error-summary alert alert-error',
        'options' => [
            'data' => [
                'id' => $model->isNewRecord ? '' : $model->id,
            ],
        ]
    ]
);
?>

<div class="modal-body">
    <div class="message"></div>
    <p>
        <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        <?= $form->field($model, 'description')->textarea(['rows' => 6]) ?>
        <?= $form->field($model, 'order')->textInput(['maxlength' => true]) ?>
    </p>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton(($model->isNewRecord ? 'Create' : 'Save'), [
        'class' => 'btn btn-primary ajax-submit',
        'data' => [
            'js-callback' => 'reloadPjaxMain',
            'submit-url' => \yii\helpers\Url::toRoute(($model->isNewRecord ? ['create'] : [
                'update',
                'id' => $model->id
            ])),
        ]
    ]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= \backend\components\helpers\JsTools::viewJs($this); ?>

