<?php

use backend\widgets\FormattedTitle;
use dmstr\bootstrap\Tabs;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\GridView;
use yii\widgets\DetailView;
use yii\widgets\Pjax;

/**
 * @var yii\web\View $this
 * @var backend\models\db\FaqQuestion $model
 */

$this->title = 'Faq Question ' . $model->title;
$this->params['breadcrumbs'][] = ['label' => 'Faq Questions', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => (string)$model->title, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = 'View';
?>
<div id="body" class="container-fluid" data-select-menu="li#admin-faq-questions" data-page-title="<?= FormattedTitle::widget( [ 'title' => $this->title ] ); ?>">
    <div class="row">
        <div class="col-md-12">
            <!-- menu buttons -->
            <p class='pull-left'>
                <?= Html::a(
                    '<span class="glyphicon glyphicon-pencil"></span> Update FAQ',
                    null,
                    [
                        'class' => 'btn btn-info open-modal',
                        'data' => [
                            'modal-url' => Url::toRoute(['update', 'id' => $model->id])
                        ]
                    ]
                ); ?>
            </p>

            <p class="pull-right">
                <?= Html::a('<span class="glyphicon glyphicon-list"></span> ' . 'List FaqQuestions', ['index'],
                    ['class' => 'btn btn-default']) ?>
            </p>

            <div class="clearfix"></div>

            <!-- flash message -->
            <?php if (\Yii::$app->session->getFlash('deleteError') !== null) : ?>
                <span class="alert alert-info alert-dismissible" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span></button>
                    <?= \Yii::$app->session->getFlash('deleteError') ?>
        </span>
            <?php endif; ?>

            <div class="panel panel-default">
                <div class="panel-heading">
                    <h2>
                        <?= $model->title ?>            </h2>
                </div>

                <div class="panel-body">


                    <?php $this->beginBlock('backend\models\db\FaqQuestion'); ?>

                    <?= DetailView::widget([
                        'model' => $model,
                        'attributes' => [
                            'id',
                            'title',
                            'description:ntext',
// generated by schmunk42\giiant\generators\crud\providers\RelationProvider::attributeFormat
                            [
                                'format' => 'html',
                                'attribute' => 'faq_category_id',
                                'value' => ($model->getFaqCategory()->one() ? Html::a($model->getFaqCategory()->one()->name,
                                    [
                                        'faq-category/view',
                                        'id' => $model->getFaqCategory()->one()->id,
                                    ]) : '<span class="label label-warning">?</span>'),
                            ],
                            'archived:boolean',
                        ],
                    ]); ?>

                    <hr/>

                    <?= Html::a('<span class="glyphicon glyphicon-trash"></span> ' . 'Delete',
                        ['delete', 'id' => $model->id],
                        [
                            'class' => 'btn btn-danger',
                            'data-confirm' => '' . 'Are you sure to delete this item?' . '',
                            'data-method' => 'post',
                        ]); ?>
                    <?php $this->endBlock(); ?>



                    <?= Tabs::widget(
                        [
                            'id' => 'relation-tabs',
                            'encodeLabels' => false,
                            'items' => [
                                [
                                    'label' => '<b class=""># ' . $model->id . '</b>',
                                    'content' => $this->blocks['backend\models\db\FaqQuestion'],
                                    'active' => true,
                                ],
                            ]
                        ]
                    );
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
