<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
?>
<div id="body" class="container-fluid secondary-nav" data-client-id="<?= $clientId; ?>" data-js-callback="notesClientDetailLoaded" data-select-menu="li#admin-notes" data-user-id="<?= $clientId ?>" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">

    <div class="row">
        <div class="col-md-7">
            <div class="col-head">
                <h3>Notes</h3>
                <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/admin/notes/add-note', 'client_id' => $clientId]) ?>"><i class="glyphicon glyphicon-plus"></i> Add</a>
            </div>
        </div>

        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="cn-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-table">
                <?= $this->render('_notes-table.php', [
                    'clientId' => $clientId
                ]); ?>
            </div>
        </div>
    </div>
</div>
