<?php
use yii\helpers\Html;
use \yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
use dosamigos\tinymce\TinyMce;
?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>

<?php $form = ActiveForm::begin(['id' => 'admin-edit-note-form']); ?>
<div class="modal-body">

    <div class="message"></div>

    <?= $form->field($formModel, 'name')->textInput() ?>
    <?= $form->field($formModel, 'content')->widget(TinyMce::className(), [
        'options' => ['rows' => 6],
        'clientOptions' => [
            'plugins' => [],
            'toolbar' => "bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link"
        ]
    ]);
    ?>
    <div class="form-group attachments-container">
        <label class="control-label">Attachments</label>
        <?php foreach ($attachments as $a) { ?>
        <div class="attachment" data-attachment-id="<?= $a->id ?>" data-modal-url="<?= Url::toRoute(['/admin/notes/edit-note', 'id' => $noteId]) ?>">
            <a href="<?= Url::to("@web/" . $a->path . $a->name) ?>" target="_blank"><?= $a->name; ?></a>
            <a class="pull-right remove-attachment" href="#">Remove</a>
        </div>
        <?php } ?>
    </div>
    <?= $form->field($formModel, 'attachment[]')->fileInput()->label(false); ?>
    <?= $form->field($formModel, 'attachment[]')->fileInput()->label(false); ?>
    <?= $form->field($formModel, 'attachment[]')->fileInput()->label(false); ?>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Edit Note', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => 'reloadNotesAfterModal', 'data-submit-url' => Url::toRoute(['/admin/notes/edit-note', 'id' => $noteId])]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>
