<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\widgets\FormattedTitle;
use backend\components\helpers\JsTools;
?>

<!---------------------------------------------------------------
Secondary Navigation
---------------------------------------------------------------->
<?= $this->render('_clients-list', [
    'clients' => $clients
]); ?>
<!---------------------------------------------------------------
End Secondary Navigation
---------------------------------------------------------------->

<!---------------------------------------------------------------
Body
---------------------------------------------------------------->
<div class="notes-container" data-block-loading="true">
    <div id="body" class="container-fluid secondary-nav" data-js-callback="notesLoaded" data-select-menu="li#admin-notes" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
        <div class="row">
            <div class="col-md-12">
                <div class="panel">
                    <?= count($clients) ? 'Loading...' : 'No clients yet.'; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!---------------------------------------------------------------
End Body
---------------------------------------------------------------->
