<?php
use backend\components\helpers\Formatter;
?>

<div class="row">
    <div class="col-<?= $size ?>-5">
        <h4>Basic information</h4>
        <div class="label-group">
            <label>Username</label>
            <div class="label-value"><?= $user->username ?></div>
        </div>
        <div class="label-group">
            <label>Email Address</label>
            <div class="label-value"><?= $user->email; ?></div>
        </div>
        <?php if (strlen($user->getFullName())) { ?>
        <div class="label-group">
            <label>Full Name</label>
            <div class="label-value"><?= $user->getFullName() ?></div>
        </div>
        <?php } ?>
        <?php if (isset($meta['birth_date']) && (strlen($meta['birth_date']) > 0)) { ?>
        <div class="label-group">
            <label>Date of Birth</label>
            <div class="label-value"><?= Formatter::date(strtotime($meta['birth_date'])) ?></div>
        </div>
        <?php } ?>
    </div>
    <div class="col-<?= $size ?>-5">
        <h4>Address & extra information</h4>
        <?php if (isset($meta['address_one_line']) && (strlen($meta['address_one_line']) > 0)) { ?>
        <div class="label-group">
            <label>Address</label>
            <div class="label-value"><?= $meta['address_one_line'] ?></div>
        </div>
        <?php } ?>
        <?php if (isset($meta['landline_number']) && (strlen($meta['landline_number']) > 0)) { ?>
        <div class="label-group">
            <label>Phone Number</label>
            <div class="label-value"><?= $meta['landline_number'] ?></div>
        </div>
        <?php } ?>
        <?php if (isset($meta['cellphone_number']) && (strlen($meta['cellphone_number']) > 0)) { ?>
        <div class="label-group">
            <label>Mobile Phone Number</label>
            <div class="label-value"><?= $meta['cellphone_number'] ?></div>
        </div>
        <?php } ?>
        <?php if (isset($meta['skype_name']) && (strlen($meta['skype_name']) > 0)) { ?>
        <div class="label-group">
            <label>Skype Account</label>
            <div class="label-value"><?= $meta['skype_name'] ?></div>
        </div>
        <?php } ?>
        <?php if (isset($meta['country_name']) && (strlen($meta['country_name']) > 0)) { ?>
        <div class="label-group">
            <label>Country</label>
            <div class="label-value"><?= $meta['country_name'] ?></div>
        </div>
        <?php } ?>
    </div>
</div>

<div class="row">
    <div class="col-<?= $size ?>-5">
        <h4>Subscription</h4>

        <div class="label-group">
            <label>Active User Plan Type</label>
            <div class="label-value"><?= $userPlan->userPlanType->name; ?></div>
        </div>

        <div class="label-group">
            <label>User Plan Activated or Extended</label>
            <div class="label-value"><?= Formatter::datetime($userPlan->start_time); ?></div>
        </div>

        <div class="label-group">
            <label>Registered Since</label>
            <div class="label-value"><?= Formatter::datetime($registration->auth_time); ?></div>
        </div>
    </div>

    <div class="col-<?= $size ?>-5">
        <h4>Activity</h4>

        <div class="label-group">
            <label>Log-ins Count This Month</label>
            <div class="label-value"><?= $loginCount; ?></div>
        </div>

        <div class="label-group">
            <label>Total Time Logged In</label>
            <div class="label-value"><?= $loginDuration; ?></div>
        </div>
    </div>

</div>

<div class="row">
    <div class="col-<?= $size ?>-12">
        <h4>Expense Changes This Month</h4>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Time</th>
                    <th>Name</th>
                    <th>Parameter</th>
                    <th>From</th>
                    <th>To</th>
                </tr>
            </thead>
            <?php if (count($expenseChanges)) { ?>
            <?php foreach ($expenseChanges as $e) { ?>
            <tr>
                <td><?= Formatter::datetime($e['time']) ?></td>
                <td><?= $e['name'] ?></td>
                <td><?= $e['parameter'] ?></td>
                <td><?= $e['from'] ?></td>
                <td><?= $e['to'] ?></td>
            </tr>
            <?php } ?>
            <?php } else { ?>
            <tr>
                <td colspan="5">No changes this month.</td>
            </tr>
            <?php } ?>
        </table>
    </div>
</div>

<div class="row">
    <div class="col-<?= $size ?>-12">
        <h4>Overspending Jars</h4>

        <?php if (count($overspendingJars)) { ?>
        <?php foreach ($overspendingJars as $o) { ?>
        <p><?= $o['name'] ?> ... <?= Formatter::currency($o['balance']) ?></p>
        <?php } ?>
        <?php } else { ?>
        <p>No overspending jars.</p>
        <?php } ?>
    </div>
</div>

<div class="row">
    <div class="col-<?= $size ?>-12">
        <h4>Notes</h4>

        <?php if (count($notes)) { ?>
        <?php foreach ($notes as $n) { ?>
        <?php if (strlen(strip_tags($n->content))) { ?>
        <div class="cr-note">
            <h5><?= $n->name ?></h5>
            <div class="content"><?= $n->content ?></div>
            <p class="last-edited">(Last edited on <?= Formatter::datetime($n->time_edited) ?>)</p>
        </div>
        <?php } ?>
        <?php } ?>
        <?php } else { ?>
        <p>No notes yet.</p>
        <?php } ?>
    </div>
</div>
