<?php
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\components\helpers\Formatter;
use backend\widgets\FormattedTitle;
use backend\components\helpers\JsTools;
?>
<div id="body" class="container-fluid user-report-container" data-js-callback="usersLoaded" data-select-menu="li.account-settings" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">

    <div class="row">
        <div class="col-lg-12">
            <div class="col-head">
                <h3>User Report</h3>
            </div>
            <div class="cr-print">
                <?= Html::a(
                    '<i class="glyphicon glyphicon-print"></i> Print Report',
                    ['/admin/user/print-consolidated-report', 'id' => $user->id],
                    ['target' => '_blank', 'class' => 'btn btn-primary']
                ) ?>
            </div>
        </div>
    </div>

    <?= $this->render('_consolidated-report', [
        'user' => $user,
        'meta' => $meta,
        'registration' => $registration,
        'userPlan' => $userPlan,
        'loginCount' => $loginCount,
        'loginDuration' => $loginDuration,
        'expenseChanges' => $expenseChanges,
        'overspendingJars' => $overspendingJars,
        'notes' => $notes,
        'size' => 'sm'
    ]) ?>

</div>
