<?php

use yii\helpers\Html;
use \yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;

?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>

<?php $form = ActiveForm::begin(['id' => 'admin-add-user-form']); ?>
<div class="modal-body">

    <div class="message"></div>

    <?= $form->field($formModel, 'username')->textInput() ?>
    <?= $form->field($formModel, 'email')->textInput() ?>
    <?= $form->field($formModel, 'password')->passwordInput() ?>
    <?= $form->field($formModel, 'password_repeat')->passwordInput()->label('Re-type password') ?>
    <?=
    $form->field($formModel, 'user_role_id')->dropDownList($userRoles,[
        'prompt' => 'Select'
    ])->label('User Role'); ?>
    <?=
    $form->field($formModel, 'user_parent_id', ['options' => ['class' => 'form-group hidden']])->dropDownList($parents,[
        'prompt' => 'Select'
    ])->label('User Parent'); ?>
    <?=
    $form->field($formModel, 'coach_id', ['options' => ['class' => 'form-group hidden']])->dropDownList($coaches,[
        'prompt' => 'Select',
    ])->label('Coach'); ?>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Save', [
        'class' => 'btn btn-primary ajax-submit',
        'data' => [
            'js-callback' => 'reloadPjaxMain',
            'submit-url' => Url::toRoute(['/admin/user/create']),
        ]
    ]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>
