<?php
use backend\components\helpers\Formatter;
use backend\components\helpers\SiteConnector;
use backend\models\db\UserPlan;
use backend\models\db\UserRole;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\GridView;
use backend\widgets\FormattedTitle;
use backend\components\helpers\JsTools;
?>

<div class="content-container user-index">
    <div id="body" class="container-fluid" data-select-menu="li#<?= $menuHtmlId ?>" data-page-title="<?= FormattedTitle::widget( [ 'title' => $this->title ] ); ?>">
        <div class="row">
            <div class="col-md-12">

                <?php \yii\widgets\Pjax::begin([
                    'id' => 'pjax-main',
                    'enableReplaceState' => true,
                ]) ?>

                <div class="col-head">
                    <h2><?= $this->title ?></h2>
                    <?php if ($this->params['initUserRole'] == 'superadmin') { ?>
                    <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['create']) ?>">
                        <i class="glyphicon glyphicon-plus"></i> Add
                    </a>
                    <?php } ?>
                </div>

                <div class="panel no-border panel-table margin-top">

                    <div class="table-responsive">
                        <?php $columns = [
                            [
                                'class' => 'yii\grid\ActionColumn',
                                'urlCreator' => function ($action, $model, $key, $index) {
                                    // using the column name as key, not mapping to 'id' like the standard generator
                                    $params = is_array($key) ? $key : [$model->primaryKey()[0] => (string)$key];
                                    $params[0] = \Yii::$app->controller->id ? \Yii::$app->controller->id . '/' . $action : $action;

                                    return Url::toRoute($params);
                                },
                                'contentOptions' => ['nowrap' => 'nowrap'],
                                'template' => '{view} {update} {reset} {delete} {switch} {consolidated-report}',
                                'buttons' => [
                                    'consolidated-report' => function ($url, $model, $key) {
                                        if (($model->userRole->name == 'client') || (($model->userRole->name == 'coach') && ($this->params['userRole'] == 'superadmin'))){
                                            return Html::a(' <i class="glyphicon glyphicon-list"></i>', $url,
                                                ['title' => 'Consolidated report for ' . $model->username, 'class' => 'system-link']);
                                        }
                                        else {
                                            return '';
                                        }
                                    },
                                    'switch' => function ($url, $model, $key) {
                                        return Html::a(
                                            '<i class="glyphicon glyphicon-random"></i>',
                                            $url,
                                            ['title' => 'Login as ' . $model->username]
                                        );
                                    },
                                    'update' => function ($url, $model, $key) {
                                        return Html::a('<span class="glyphicon glyphicon-pencil"></span>',
                                            '#', [
                                                'title' => 'Update',
                                                'aria-label' => 'Update',
                                                'class' => 'open-modal',
                                                'data' => [
                                                    'modal-url' => $url
                                                ]
                                            ]);
                                    },
                                    'delete' => function ($url, $model, $key) {
                                        if ($this->params['initUserRole'] == 'superadmin') {
                                            return Html::a('<span class="glyphicon glyphicon-trash"></span>',
                                                '#', [
                                                    'title' => 'Archive',
                                                    'aria-label' => 'archive',
                                                    'class' => 'open-modal',
                                                    'data' => [
                                                        'modal-url' => $url
                                                    ]
                                                ]);
                                        }
                                        else {
                                            return '';
                                        }
                                    },
                                    'reset' => function ($url, $model, $key) {
                                        if ($this->params['initUserRole'] == 'superadmin' && $model->user_role_id == UserRole::CLIENT) {
                                            return Html::a('<span class="glyphicon glyphicon-ban-circle"></span>',
                                                '#', [
                                                    'title' => 'Reset Account',
                                                    'aria-label' => 'reset',
                                                    'class' => 'open-modal',
                                                    'data' => [
                                                        'modal-url' => $url
                                                    ]
                                                ]);
                                        }
                                        else {
                                            return '';
                                        }
                                    }
                                ]
                            ],
                            'username',
                            'email'
                        ];
                        if (!empty($planTypes)) {
                            $columns[] = [
                                'attribute' => 'userPlanType',
                                'label' => 'Plan Type',
                                'format' => 'raw',
                                'value' => function ($m) {
                                    $up = UserPlan::getActivePlan($m->id);
                                    return $up ? $up->userPlanType->name : '<i>none</i>';
                                },
                                'filter' => \yii\helpers\ArrayHelper::map($planTypes, 'id', 'name'),
                            ];
                            $columns[] = [
                                'attribute' => 'user_role_id',
                                'value' => function ($m) {
                                    return $m->userRole->name;
                                },
                                'format' => 'raw',
                                'filter' => \yii\helpers\ArrayHelper::map($userRoles, 'id', 'name')
                            ];
                            $columns[] = [
                                'attribute' => 'created_at',
                                'label' => 'Registration Date',
                                'value' => function ($m) {
                                    return Formatter::date($m->created_at);
                                },
                                'format' => 'raw',
                                'filter' => \dosamigos\datepicker\DatePicker::widget([
                                    'model' => $searchModel,
                                    'attribute' => 'created_at',
                                    'template' => '{input}{addon}',
                                    'options' => [
                                        'readonly' => true
                                    ],
                                    'clientOptions' => [
                                        'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
                                        'minView' => 'month',
                                        'maxView' => 'year',
                                        'clearBtn' => true,
                                        'autoclose' => true
                                    ]
                                ])
                            ];
                        }
                        $columns[] = 'archived:boolean';
                        if (isset(Yii::$app->getComponents()['siteConnector'])) {
                            $membersList = Yii::$app->siteConnector->getAllUsers();
                            $columns[] = [
                                'label' => 'Membership Site Access',
                                'value' => function ($m) use ($membersList) {
                                $membershipUser = $m->isMembershipUser($membersList);
                                    return $membershipUser ?
                                        'Yes (' . SiteConnector::getMembershipLevelDescription($membershipUser) . ')' :
                                        'No (' . Html::a('synchronize', ['/admin/user/sync', 'id' => $m->id]) . ')';
                                },
                                'format' => 'raw'
                            ];
                        }
                        ?>
                        <?= GridView::widget([
                            'layout' => '{pager}{items}{pager}{summary}',
                            'dataProvider' => $dataProvider,
                            'pager' => [
                                'class' => yii\widgets\LinkPager::className(),
                                'firstPageLabel' => 'First',
                                'lastPageLabel' => 'Last'
                            ],
                            'filterModel' => $searchModel,
//                            'tableOptions' => ['class' => 'table table-striped table-bordered table-hover'],
                            //'headerRowOptions' => ['class' => 'x'],
                            'options' => ['pjax' => true],
                            'columns' => $columns,
                        ]); ?>
                    </div>

                </div>

                <?php \yii\widgets\Pjax::end() ?>

            </div>
        </div>
    </div>
</div>
<?= JsTools::viewJs($this); ?>
