<?php

namespace backend\modules\api\components;

use backend\models\db\Account;
use backend\models\db\Budget;
use backend\models\db\Income;
use backend\models\db\IncomeTransaction;
use backend\models\db\Jar;
use backend\models\db\User;
use Yii;
use yii\caching\TagDependency;
use yii\rest\Action;
use yii\rest\Serializer;
use yii\web\ServerErrorHttpException;


class CreateIncomeTransaction extends Action
{
    public $scenario = 'api';
    protected $userId;


    public function run()
    {
        if ($this->checkAccess) {
            call_user_func($this->checkAccess, $this->id);
        }
        Yii::warning(print_r(Yii::$app->getRequest()->getBodyParams(), true));
        $this->userId = Yii::$app->session->get('mainUserId');

        /* @var $model IncomeTransaction */
        $model = new $this->modelClass([
            'scenario' => $this->scenario,
        ]);

        $model->load(Yii::$app->getRequest()->getBodyParams(), '');
        if (!$model->validate()) {
            return $model;
        }

        $account = Account::find()
            ->joinWith('budget')
            ->where([
                Account::tableName() . '.id' => $model->account_id,
                'user_id' => $this->userId
            ])
            ->one();
        if (!$account) {
            $model->addError('account_id', 'Invalid account selected.');
            return $model;
        }
        if ($model->income_id) {
            $income = Income::find()
                ->joinWith('budget')
                ->where([
                    Income::tableName() . '.id' => $model->income_id,
                    'user_id' => $this->userId
                ])
                ->one();
            if (!$income) {
                $model->addError('income_id', 'Invalid income selected.');
                return $model;
            }
        }
        else {
            // one-off income
            $budgetId = User::findOne($this->userId)->getActiveBudgetId($this->userId);
            $income = new Income();
            $income->setAttributes([
                'budget_id' => $budgetId,
                'account_id' => $model->account_id,
                'name' => Income::OTHER_INCOME_NAME,
                'amount' => $model->amount,
                'date' => $model->date,
                'frequency' => 'one-time',
                'is_unbudgeted' => 1
            ]);
            if ($model->jar_id) {
                $income->jar_id = $model->jar_id;
            }
            // FIXME: workaround to not create the transaction record automatically so a description can be added
            $income->is_adjustment = 1;
            if (!$income->save()) {
                $income->addError('name', 'Error occurred during saving the income record.');
                return $income;
            }
            else {
                $income->is_adjustment = 0;
                $income->save();
            }
            $model->income_id = $income->id;
        }

        $model->income_name = $income->name;
        $model->jar_id = $income->jar_id;
        $model->account_name = $account->name;
        $model->jar_name = $income->jar_id ? $income->jar->name : null;

        if ($model->save()) {
            if ($model->jar_id) {
                TagDependency::invalidate(Yii::$app->cache, 'jarFundsRemaining-' . $model->jar_id);
            }
            $response = Yii::$app->getResponse();
            $response->setStatusCode(201);
        } elseif (!$model->hasErrors()) {
            throw new ServerErrorHttpException('Failed to create the object for unknown reason.');
        }

        $serializer = new Serializer();
        return array_merge(
            $serializer->serialize($model),
            ['jar' => $model->jar_id ? Jar::findOne($model->jar_id) : null]
        );
    }
}