<?php

namespace backend\modules\api\components;

use backend\models\db\Account;
use backend\models\db\Expense;
use backend\models\db\ExpenseEnd;
use backend\models\db\Jar;
use backend\models\db\Transaction;
use Yii;
use yii\caching\TagDependency;
use yii\rest\Action;
use yii\rest\Serializer;
use yii\web\ServerErrorHttpException;


class CreateTransaction extends Action
{
    public $scenario = 'api';
    protected $userId;


    public function run()
    {
        if ($this->checkAccess) {
            call_user_func($this->checkAccess, $this->id);
        }
        Yii::warning(print_r(Yii::$app->getRequest()->getBodyParams(), true));
        $this->userId = Yii::$app->session->get('mainUserId');

        /* @var $model Transaction */
        $model = new $this->modelClass([
            'scenario' => $this->scenario,
        ]);

        $model->load(Yii::$app->getRequest()->getBodyParams(), '');
        if (!$model->validate()) {
            return $model;
        }

        $account = Account::find()
            ->joinWith('budget')
            ->where([
                Account::tableName() . '.id' => $model->account_id,
                'user_id' => $this->userId
            ])
            ->one();
        if (!$account) {
            $model->addError('account_id', 'Invalid account selected.');
            return $model;
        }
        if ($model->expense_id) {
            $expense = Expense::find()
                ->joinWith('account.budget')
                ->where([
                    Expense::tableName() . '.id' => $model->expense_id,
                    'user_id' => $this->userId
                ])
                ->one();
            if (!$expense) {
                $model->addError('expense_id', 'Invalid expense selected.');
                return $model;
            }
        }
        else {
            if (empty($model->jar_id)) {
                $model->addError('jar_id', 'Jar ID cannot be blank.');
                return $model;
            }
            // create one-off expense
            $expense = new Expense();
            $expense->setAttributes([
                'jar_id' => $model->jar_id,
                'name' => Expense::OTHER_UNBUDGETED_EXPENSE_NAME,
                'account_id' => $model->account_id,
                'amount' => $model->amount,
                'date' => $model->date,
                'frequency' => 'one-time',
                'is_unbudgeted' => 1,
                'is_adjustment' => 0,
                'tax_deductible' => 0,
                'generate_transactions' => 0
            ]);
            if (!$expense->save()) {
                $expense->addError('name', 'Error occurred during saving the expense record.');
                return $expense;
            }
            $model->expense_id = $expense->id;
        }

        $model->account_name = $account->name;
        $model->name = $expense->name;
        $model->jar_id = $expense->jar_id;
        $model->jar_name = $expense->jar_id ? $expense->jar->name : null;

        if ($model->save()) {
            if ($model->jar_id) {
                TagDependency::invalidate(Yii::$app->cache, 'jarFundsRemaining-' . $model->jar_id);
            }
            $response = Yii::$app->getResponse();
            $response->setStatusCode(201);
        } elseif (!$model->hasErrors()) {
            throw new ServerErrorHttpException('Failed to create the object for unknown reason.');
        }

        $serializer = new Serializer();
        return array_merge(
            $serializer->serialize($model),
            ['jar' => $model->jar_id ? Jar::findOne($model->jar_id) : null]
        );
    }
}