<?php
use yii\helpers\Html;

/* @var $this \yii\web\View view component instance */
/* @var $message \yii\mail\MessageInterface the message being composed */
/* @var $content string main view render result */
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <title><?= Html::encode($this->title) ?></title>
        <meta property="og:title" content="">
        <meta name="twitter:title" content="">
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <style type="text/css" id="hs-inline-css">
            /*<![CDATA[*/
            /* everything in this node will be inlined */

            /* ==== Page Styles ==== */

            body, #backgroundTable {
                background-color: #F2F2F2; /* Use body to determine background color */
                font-family: sans-serif;
            }
            #templateTable {
                width: 600px;
                background-color: #ffffff;
                -webkit-font-smoothing: antialiased;
            }
            h1, .h1, h2, .h2, h3, .h3, h4, .h4, h5, .h5, h6, .h6 {
                color: #444444;
                display: block;
                font-family: sans-serif;
                font-weight: bold;
                line-height: 100%;
                margin-top: 0;
                margin-right: 0;
                margin-bottom: 10px;
                margin-left: 0;
                text-align: left;
            }
            h1, .h1 {
                font-size: 26px;
            }
            h2, .h2 {
                font-size: 20px;
            }
            h3, .h3 {
                font-size: 15px;
            }
            h4, .h4 {
                font-size: 13px;
            }
            h5, .h5 {
                font-size: 11px;
            }
            h6, .h6 {
                font-size: 10px;
            }
            /* ==== Header Styles ==== */

            #headerTable {
                background-color: #F2F2F2;
                color: #444444;
                font-family: sans-serif;
                font-size: 10px;
                line-height: 120%;
                text-align: right;
                border-collapse: separate !important;
                padding-right: 0px;
            }
            #headerTable a:link, #headerTable a:visited, /* Yahoo! Mail Override */ #headerTable a .yshortcuts /* Yahoo! Mail Override */ {
                font-weight: normal;
                text-decoration: underline;
            }
            /* ==== Template Wrapper Styles ==== */

            #contentCell {
                padding: 10px 20px;
                background-color: #F2F2F2;
            }
            #contentTableOuter {
                border-collapse: separate !important;
                background-color: #ffffff;
                padding: 0px;
            }
            #contentTableInner {
                width: 600px;
            }
            /* ==== Body Styles ==== */

            .bodyContent {
                color: #444444;
                font-family: sans-serif;
                font-size: 14px;
                line-height: 150%;
                text-align: left;
            }
            /* ==== Column Styles ==== */

            table.columnContentTable {
                border-collapse: separate !important;
                border-spacing: 0;
                background-color: #ffffff;
            }
            td[class~="columnContent"] {
                color: #444444;
                font-family: sans-serif;
                font-size: 14px;
                line-height: 120%;
                padding-top: 20px;
                padding-right: 20px;
                padding-bottom: 20px;
                padding-left: 20px;
            }
            /* ==== Footer Styles ==== */

            #footerTable {
                background-color: #F2F2F2;
            }
            #footerTable a {
                color: #999999;
            }
            #footerTable {
                color: #999999;
                font-family: sans-serif;
                font-size: 12px;
                line-height: 120%;
                padding-top: 20px;
                padding-right: 20px;
                padding-bottom: 20px;
                padding-left: 20px;
                text-align: center;
            }
            #footerTable a:link, #footerTable a:visited, /* Yahoo! Mail Override */ #footerTable a .yshortcuts /* Yahoo! Mail Override */ {
                font-weight: normal;
                text-decoration: underline;
            }
            .hs-image-social-sharing-24 {
                max-width: 24px;
                max-height: 24px;
            }
            /* ==== Standard Resets ==== */
            .ExternalClass {
                width: 100%;
            } /* Force Hotmail to display emails at full width */
            .ExternalClass, .ExternalClass p, .ExternalClass span, .ExternalClass font, .ExternalClass td, .ExternalClass div {
                line-height: 100%;
            } /* Force Hotmail to display normal line spacing */
            body, table, td, p, a, li, blockquote {
                -webkit-text-size-adjust: 100%;
                -ms-text-size-adjust: 100%;
            } /* Prevent WebKit and Windows mobile changing default text sizes */
            table, td {
                mso-table-lspace: 0pt;
                mso-table-rspace: 0pt;
            } /* Remove spacing between tables in Outlook 2007 and up */
            img {
                vertical-align: bottom;
                -ms-interpolation-mode: bicubic;
            } /* Allow smoother rendering of resized image in Internet Explorer */
            /* Reset Styles */
            body {
                margin: 0;
                padding: 0;
            }
            table {
                border-collapse: collapse !important;
            }
            body, #backgroundTable, #bodyCell {
                height: 100% !important;
                margin: 0;
                padding: 0;
                width: 100% !important;
            }
            a:link, a:visited {
                border-bottom: none;
            }
            /* iOS automatically adds a link to addresses */
            /* Style the footer with the same color as the footer text */
            #footer a {
                color: #999999;
            ;
                -webkit-text-size-adjust: none;
                text-decoration: underline;
                font-weight: normal
            }
            /*]]>*/
        </style>
        <style type="text/css">
            /*<![CDATA[*/
            /* ==== Mobile Styles ==== */

            /* Constrain email width for small screens */
            @media screen and (max-width: 650px) {
                table[id="backgroundTable"] {
                    width: 95% !important;
                }

                table[id="templateTable"] {
                    max-width:600px !important;
                    width:100% !important;
                }

                table[id="contentTableInner"] {
                    max-width:600px !important;
                    width:100% !important;
                }

                /* Makes image expand to take 100% of width*/
                img {
                    width: 100% !important;
                    height: auto !important;
                }

                #contentCell {
                    padding: 10px 10px !important;
                }

                #headerTable {
                    padding-right: 0.0px !important;
                }

                #contentTableOuter {
                    padding: 0.0px !important;
                }
            }

            @media only screen and (max-width: 480px) {
                /* ==== Client-Specific Mobile Styles ==== */
                body, table, td, p, a, li, blockquote{
                    -webkit-text-size-adjust:none !important;
                } /* Prevent Webkit platforms from changing default text sizes */
                body{
                    width:100% !important;
                    min-width:100% !important;
                } /* Prevent iOS Mail from adding padding to the body */

                /* ==== Mobile Reset Styles ==== */
                td[id="bodyCell"] {
                    padding:10px !important;
                }

                /* ==== Mobile Template Styles ==== */

                table[id="templateTable"] {
                    max-width:600px !important;
                    width:100% !important;
                }

                table[id="contentTableInner"] {
                    max-width:600px !important;
                    width:100% !important;
                }

                /* ==== Image Alignment Styles ==== */

                h1, .h1 {
                    font-size:26px !important;
                    line-height:125% !important;
                }

                h2, .h2 {
                    font-size:20px !important;
                    line-height:125% !important;
                }

                h3, .h3 {
                    font-size:15px !important;
                    line-height:125% !important;
                }

                h4, .h4 {
                    font-size:13px !important;
                    line-height:125% !important;
                }

                h5, .h5 {
                    font-size:11px !important;
                    line-height:125% !important;
                }

                h6, .h6 {
                    font-size:10px !important;
                    line-height:125% !important;
                }

                .hide {
                    display:none !important;
                } /* Hide to save space */

                /* ==== Body Styles ==== */

                td[class="bodyContent"] {
                    font-size:16px !important;
                    line-height:145% !important;
                }

                /* ==== Footer Styles ==== */

                td[id="footerTable"]{
                    padding-left: 0px !important;
                    padding-right: 0px !important;
                    font-size:12px !important;
                    line-height:145% !important;
                }

                /* ==== Image Alignment Styles ==== */

                table[class="alignImageTable"] {
                    width: 100% !important;
                }

                td[class="imageTableTop"] {
                    display: none !important;
                    /*padding-top: 10px !important;*/
                }
                td[class="imageTableRight"] {
                    display: none !important;
                }
                td[class="imageTableBottom"] {
                    padding-bottom: 10px !important;
                }
                td[class="imageTableLeft"] {
                    display: none !important;
                }

                /* ==== Column Styles ==== */

                td[class~="column"] {
                    display: block !important;
                    width: 100% !important;
                    padding-top: 0 !important;
                    padding-right: 0 !important;
                    padding-bottom: 0 !important;
                    padding-left: 0 !important;
                }

                td[class~=columnContent] {
                    font-size:14px !important;
                    line-height:145% !important;

                    padding-top: 10px !important;
                    padding-right: 10px !important;
                    padding-bottom: 10px !important;
                    padding-left: 10px !important;
                }

                #contentCell {
                    padding: 10px 0px !important;
                }

                #headerTable {
                    padding-right: 0.0px !important;
                }

                #contentTableOuter {
                    padding: 0.0px !important;
                }
            }
            /*]]>*/
        </style>

        <!-- http://www.emailon@cid.com/blog/details/C13/ensure_that_your_entire_email_is_rendered_by_default_in_the_iphone_ipad -->
        <!--                                                                                                                     -->
        <!--                                                                                                                     -->
        <!--                            _/    _/            _/          _/_/_/                        _/                         -->
        <!--                           _/    _/  _/    _/  _/_/_/    _/        _/_/_/      _/_/    _/_/_/_/                      -->
        <!--                          _/_/_/_/  _/    _/  _/    _/    _/_/    _/    _/  _/    _/    _/                           -->
        <!--                         _/    _/  _/    _/  _/    _/        _/  _/    _/  _/    _/    _/                            -->
        <!--                        _/    _/    _/_/_/  _/_/_/    _/_/_/    _/_/_/      _/_/        _/_/                         -->
        <!--                                                               _/                                                    -->
        <!--                                                              _/                                                     -->
        <!--                                                                                                                     -->
        <!--                                                 Extra White Space!                                                  -->
        <!--                                                                                                                     -->
        <!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->
        <meta name="generator" content="HubSpot">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <?php $this->head() ?>
    </head>
    <body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0" style="background-color:#f2f2f2; font-family:sans-serif; -webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; height:100% !important; margin:0; padding:0; width:100% !important" bgcolor="#f2f2f2" height="100% !important" width="100% !important">
    <!-- Preview text (text which appears right after subject) -->

    <!--  The  backgroundTable table manages the color of the background and then the templateTable maintains the body of
            the email template, including preheader & footer. This is the only table you set the width of to, everything else is set to
            100% and in the CSS above. Having the width here within the table is just a small win for Lotus Notes. -->

    <!-- Begin backgroundTable -->
    <table align="center" bgcolor="#f2f2f2" border="0" cellpadding="0" cellspacing="0" height="100% !important" width="100% !important" id="backgroundTable" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; border-collapse:collapse !important; background-color:#f2f2f2; font-family:sans-serif; height:100% !important; margin:0; padding:0; width:100% !important">
        <tbody>
        <tr>
            <td align="center" valign="top" id="bodyCell" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; height:100% !important; margin:0; padding:0; width:100% !important" height="100% !important" width="100% !important"><!-- When nesting tables within a TD, align center keeps it well, centered. -->
                <!-- Begin Template Container -->
                <!-- This holds everything together in a nice container -->

                <table border="0" cellpadding="0" cellspacing="0" id="templateTable" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; border-collapse:collapse !important; width:600px; background-color:#ffffff; -webkit-font-smoothing:antialiased" width="600" bgcolor="#ffffff">
                    <tbody>
                    <tr>
                        <td align="center" valign="top" id="contentCell" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; padding:10px 20px; background-color:#f2f2f2" bgcolor="#f2f2f2"><!-- Begin Template Wrapper -->
                            <!-- This separates the preheader which usually contains the "open in browser, etc" content
                                            from the actual body of the email. Can alternatively contain the footer too, but I choose not
                                            to so that it stays outside of the border. -->

                            <table border="0" cellpadding="0" cellspacing="0" width="100%" id="contentTableOuter" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; border-collapse:separate !important; background-color:#ffffff; padding:0px" bgcolor="#ffffff">
                                <tbody>
                                <tr>
                                    <td align="center" valign="top" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt">
                                        <table border="0" cellpadding="0" cellspacing="0" id="contentTableInner" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; border-collapse:collapse !important; width:600px" width="600">
                                            <tbody>
                                            <tr>
                                                <td align="left" valign="top" class="bodyContent" width="100%" colspan="12" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; color:#444444; font-family:sans-serif; font-size:14px; line-height:150%; text-align:left"><table cellpadding="0" cellspacing="0" border="0" width="100%" class="templateColumnWrapper" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; border-collapse:collapse !important">
                                                        <tbody>
                                                        <tr>
                                                            <td valign="top" colspan="12" width="100.0%" class=" column" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; width:100.0%; text-align:left; padding:0; font-family:sans-serif; font-size:14px; line-height:1.5em; color:#444444" align="left"><table border="0" cellpadding="0" cellspacing="0" width="100%" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; border-collapse:separate !important; border-spacing:0; background-color:#30445d" class=" columnContentTable" bgcolor="#30445d">
                                                                    <tbody>
                                                                    <tr>
                                                                        <td align="center" valign="top" class="columnContent widget-span widget-type-linked_image" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; text-align:left; padding:0; font-family:sans-serif; font-size:14px; line-height:1.5em; color:#444444; font-size:18px; font-family:Georgia, serif; height:70px; text-align:center; color:#ffffff" data-widget-type="linked_image" height="70"><div class="layout-widget-wrapper">
                                                                                <div id="hs_cos_wrapper_module_14383435384641465" class="hs_cos_wrapper hs_cos_wrapper_widget hs_cos_wrapper_type_linked_image" style="color: inherit; font-size: inherit; line-height: inherit;" data-hs-cos-general-type="widget" data-hs-cos-type="linked_image"><a href="http://www.grandmasjars.com" id="hs-link-module_14383435384641465" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; border-width:0px; border:0px" data-hs-link-id="0" target="_blank"><img src="https://cdn2.hubspot.net/hub/460432/hubfs/images/email_images/Newsletter/grandmas-jars.png?width=600&name=grandmas-jars.png" class="hs-image-widget " style="vertical-align:bottom; -ms-interpolation-mode:bicubic; max-height:70px; max-width:600px; border-width:0px; border:0px" width="600" alt="Grandma's Jars | Transforming lives, one budget at a time" title="Grandma's Jars | Transforming lives, one budget at a time"></a></div>
                                                                            </div>
                                                                            <!--end layout-widget-wrapper --></td>
                                                                    </tr>
                                                                    </tbody>
                                                                </table>
                                                                <!--end widget-table --></td>
                                                        </tr>
                                                        </tbody>
                                                    </table></td>
                                            </tr>
                                            <tr>
                                                <td align="left" valign="top" class="bodyContent" width="100%" colspan="12" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; color:#444444; font-family:sans-serif; font-size:14px; line-height:150%; text-align:left"><table cellpadding="0" cellspacing="0" border="0" width="100%" class="templateColumnWrapper" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; border-collapse:collapse !important">
                                                        <tbody>
                                                        <tr>
                                                            <td valign="top" colspan="12" width="100.0%" class=" column" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; width:100.0%; text-align:left; padding:0; font-family:sans-serif; font-size:14px; line-height:1.5em; color:#444444; font-family:Arial, sans-serif; font-size:14px; padding:0px 35px 25px 35px; color:#333333" align="left"><table cellpadding="0" cellspacing="0" border="0" width="100%" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; border-collapse:collapse !important">
                                                                    <tbody>
                                                                    <tr>
                                                                        <td align="left" valign="top" class="bodyContent" width="100%" colspan="12" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; color:#444444; font-family:sans-serif; font-size:14px; line-height:150%; text-align:left"><table cellpadding="0" cellspacing="0" border="0" width="100%" class="templateColumnWrapper" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; border-collapse:collapse !important">
                                                                                <tbody>
                                                                                <tr>
                                                                                    <td valign="top" colspan="12" width="100.0%" class=" column" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; width:100.0%; text-align:left; padding:0; font-family:sans-serif; font-size:14px; line-height:1.5em; color:#444444" align="left"><table border="0" cellpadding="0" cellspacing="0" width="100%" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; border-collapse:separate !important; border-spacing:0; background-color:#ffffff" class=" columnContentTable" bgcolor="#ffffff">
                                                                                            <tbody>
                                                                                            <tr>
                                                                                                <td align="left" valign="top" class="columnContent widget-span widget-type-email_body" style="-webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; mso-table-lspace:0pt; mso-table-rspace:0pt; text-align:left; padding:0; font-family:sans-serif; font-size:14px; line-height:1.5em; color:#444444; padding:0px 0px 10px 0px" data-widget-type="email_body">
                                                                                                    <div id="hs_cos_wrapper_hs_email_body" class="hs_cos_wrapper hs_cos_wrapper_widget hs_cos_wrapper_type_rich_text" style="color: inherit; font-size: inherit; line-height: inherit;" data-hs-cos-general-type="widget" data-hs-cos-type="rich_text">
                                                                                                        <p style="margin-bottom: 1em; -webkit-text-size-adjust:100%; -ms-text-size-adjust:100%"><span style="font-weight: 400;">&nbsp;</span></p>
                                                                                                        <?php $this->beginBody() ?>
                                                                                                        <?= $content ?>
                                                                                                        <p>
                                                                                                            Thanks,<br/>
                                                                                                            The Grandma’s Jars Team
                                                                                                        </p>
                                                                                                        <?php $this->endBody() ?>
                                                                                                    </div>
                                                                                                </td>
                                                                                            </tr>
                                                                                            </tbody>
                                                                                        </table>
                                                                                        <!--end widget-table --></td>
                                                                                </tr>
                                                                                </tbody>
                                                                            </table></td>
                                                                    </tr>
                                                                    </tbody>
                                                                </table></td>
                                                        </tr>
                                                        </tbody>
                                                    </table></td>
                                            </tr>
                                            <!--end body wrapper -->
                                            </tbody>
                                        </table></td>
                                </tr>
                                </tbody>
                            </table>

                            <!-- End Template Wrapper --></td>
                    </tr>
                    </tbody>
                </table>

                <!-- End Template Container --></td>
        </tr>
        </tbody>
    </table>
    </body>
    </html>
<?php $this->endPage() ?>