<?php
use yii\helpers\Url;
use backend\components\helpers\Formatter;
?>

<nav id="secondary-side-bar" class="navmenu navmenu-default navmenu-fixed-left accounts-side-bar" role="navigation">
    <div id="seconday-side-bar-header">
        <h2><?= ($allowEdit) ? 'Accounts' : 'Deleted Accounts'; ?></h2>
        <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::to(['/accounts/add-account', 'budget_id' => (isset($budgetId) ? $budgetId : false)]) ?>">
            <i class="glyphicon glyphicon-plus"></i> Add
        </a>
        <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::to(['/accounts/add-account', 'budget_id' => (isset($budgetId) ? $budgetId : false), 'type' => 'cc']) ?>">
            <i class="glyphicon glyphicon-plus"></i> Add CC
        </a>
    </div>
    <ul id="secondary-side-bar-nav" class="nav navmenu-nav panel-group accounts" role="tablist" aria-multiselectable="true">
        <?php foreach ($accounts as $a) {
            $classCont = (isset($account) && ($a->id == $account->id)) ? 'active' : '';
            if ($defaultAccountId == $a->id) {
                if (strlen($classCont)) {
                    $classCont .= ' ';
                }
                $classCont .= 'default-account';
            }
            $classHtml = (strlen($classCont)) ? ' class="' . $classCont . '"' : '';
        ?>
        <li data-account-id="<?= $a->id ?>"<?= $classHtml; ?>>
            <a href="<?= Url::toRoute(['accounts/account-detail', 'id' => $a->id]) ?>">
                <div class="info">
                    <h4><?= $a->name ?></h4>
                    <h5><?= Formatter::currency($a->getCurrentBalance()) ?></h5>
                </div>
            </a>
        </li>
        <?php } ?>
    </ul>
</nav>
