<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\widgets\FormattedTitle;
?>

<!---------------------------------------------------------------
Secondary Navigation
---------------------------------------------------------------->
<?= $this->render('_accounts-list', [
    'budgetId' => $budgetId,
    'accounts' => $accounts,
    'defaultAccountId' => $defaultAccountId,
    'allowEdit' => $allowEdit
]); ?>
<!---------------------------------------------------------------
End Secondary Navigation
---------------------------------------------------------------->

<!---------------------------------------------------------------
Body
---------------------------------------------------------------->
<div class="account-container content-container" data-block-loading="true">
    <div id="body" class="container-fluid secondary-nav"
         data-js-callback="accountsLoaded"
         data-select-menu="li#my-financials-accounts"
         data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
        <div class="row">
            <div class="col-md-12">
                <div class="panel">
                    <?= count($accounts) ? 'Loading...' : 'No accounts yet.'; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!---------------------------------------------------------------
End Body
---------------------------------------------------------------->
