<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'remove-account-form']); ?>
<div class="modal-body">

    <h4>To remove an account, please fill-in the following fields:</h4>

    <div class="message"></div>

    <?= $form->field($formModel, 'new_account_id')->dropDownList($otherAccountsWithNone, [
        'prompt' => 'Select one'
    ])->label('Transfer account funds to:') ?>

    <?php if (count($debts)) { ?>
    <h4>Assign all debts to this account:</h4>
    <?= $form->field($formModel, 'debt_account_id')->dropDownList($otherAccounts, [
        'prompt' => 'Select one'
    ])->label(false) ?>
    <?php } ?>

    <?php if (count($expenses)) { ?>
    <h4>Assign all expenses to this account:</h4>
    <?= $form->field($formModel, 'expense_account_id')->dropDownList($otherAccounts, [
        'prompt' => 'Select one'
    ])->label(false) ?>
    <?php } ?>

    <?php if (count($incomes)) { ?>
    <h4>Assign all incomes to this account:</h4>
    <?= $form->field($formModel, 'income_account_id')->dropDownList($otherAccounts, [
        'prompt' => 'Select one'
    ])->label(false) ?>
    <?php } ?>

    <?php if (count($transfers)) { ?>
    <h4>Assign all transfers to this account:</h4>
    <?= $form->field($formModel, 'transfer_account_id')->dropDownList($otherAccounts, [
        'prompt' => 'Select one'
    ])->label(false) ?>
    <?php } ?>

    <?php if (isset($isDefaultAccount) && $isDefaultAccount) { ?>
    <h4>Select new "Central Account":</h4>
    <?= $form->field($formModel, 'default_account_id')->dropDownList($otherAccounts, [
        'prompt' => 'Select one'
    ])->label(false) ?>
    <?php } ?>

    <?php if ($hardDeletable) { ?>
    <ul>
        <li><strong>Delete Account</strong> when the account is no longer valid (keeps past expense data).</li>
        <li>
            <strong>Delete Account and all Associated Transactions</strong> when the account was added in a mistake (deletes all past and current data).<br/>
            <strong>No funds are transferred with this option.</strong>
        </li>
    </ul>
    <?php } ?>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Delete Account', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadAccountsAfterRemove'), 'data-submit-url' => Url::toRoute(['/accounts/remove-account', 'id' => $accountId, 'confirm' => '1'])]) ?>
    <?php if ($hardDeletable) { ?>
    <?= Html::submitButton(
        'Delete Account and all Associated Transactions',
        [
            'class' => 'btn btn-danger ajax-submit',
            'data-js-callback' => JsTools::jsCallback($this, 'reloadAccountsAfterRemove'),
            'data-submit-url' => Url::toRoute(['/accounts/remove-account', 'id' => $accountId, 'confirm' => 1, 'hard' => 1]),
            'onclick' => "$('#removeaccount-new_account_id').val('0')"
        ]
    ) ?>
    <?php } ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>
