<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'add-appointment-form']); ?>
<div class="modal-body">
    <div class="message"></div>
    <?= $form->field($formModel, 'year')->dropDownList($years) ?>

    <?= $form->field($formModel, 'month')->dropDownList($months) ?>

    <div class="time-slots">
        <div class="time-slot clearfix">
            <?php if (!$amPm) { ?>
            <div class="col-sm-4">
                <?= $form->field($formModel, 'day[0]') ?>
            </div>
            <div class="col-sm-4">
            <?= $form->field($formModel, 'hour[0]') ?>
            </div>
            <div class="col-sm-4">
            <?= $form->field($formModel, 'minute[0]') ?>
            </div>
            <?php } else { ?>
            <div class="col-sm-3">
                <?= $form->field($formModel, 'day[0]') ?>
            </div>
            <div class="col-sm-3">
            <?= $form->field($formModel, 'hour[0]') ?>
            </div>
            <div class="col-sm-3">
            <?= $form->field($formModel, 'minute[0]'); ?>
            </div>
            <div class="col-sm-3">
            <?= $form->field($formModel, 'pm[0]')->checkbox(['template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"])->label('Check for PM.') ?>
            </div>
            <?php } ?>
            <div class="col-sm-12">
                <a href="#" class="remove-time-slot">Remove</a>
            </div>
        </div>

        <div class="col-sm-12">
            <a href="#" class="add-time-slot">
                <i class="glyphicon glyphicon-plus-sign gi-2x"></i> Add time-slot
            </a>
        </div>

    </div>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Add Time-slot(s)', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => 'reloadAppointmentsDay', 'data-submit-url' => Url::toRoute('/appointments/add-appointment')]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>


