<?php
use backend\models\db\Jar;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;
use backend\components\helpers\Calculator;
use backend\widgets\VideoTutorial;
?>

<div id="body" class="container-fluid" data-select-menu=".panel.dashboard" data-js-callback="bodyLoaded" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <?= VideoTutorial::widget(['type' => 'dashboard']) ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3>Dashboard</h3>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-3 dashboard-financial-position">
            <div class="col-head">
                <h4>Financial Position</h4>
            </div>
            <div class="panel">
                <?= $this->render('/budget/_dashboard-financial-position-graph', [
                    'year' => date('Y'),
                    'month' => date('m'),
                    'netPosition' => $netPosition,
                    'totalAccounts' => $totalAccounts,
                    'totalDebt' => $totalDebt
                ]); ?>
            </div>
        </div>
        <div class="col-md-9 dashboard-recent-transactions">
            <div class="col-head">
                <h4>
                    Recent Transactions
                    <a class="btn btn-primary btn-sm open-modal" data-modal-url="/transactions/add-es-transaction">+ Add Transaction</a>
                </h4>
            </div>
            <div class="panel panel-table expenses-panel onetime-expenses">
                <?= $this->render('/money-operations/_money-operations-table', [
                    'moneyOperationsAmount' => null,
                    'year' => date('Y'),
                    'month' => date('m')
                ]); ?>
            </div>
        </div>
    </div>

    <?php if ($eoms) { ?>
    <div class="row">
        <div class="col-md-9">
            <div class="col-head">
                <h4>Last 12 Months' End of Month Summaries</h4>
            </div>
            <?php if ($showTwelveMonthEoms) { ?>
            <div class="panel">
                <?= $this->render('/budget/_end-of-month-summary-balances-graph', [
                    'until' => date('Y-m', strtotime('-1 month', strtotime(date('Y-m-20'))))
                ]); ?>
            </div>
            <?php } else { ?>
            <p>No End of Month Summaries yet.</p>
            <?php } ?>
        </div>
        <div class="col-md-3 dashboard-last-eoms">
            <div class="col-head">
                <h4><?= date('F', strtotime("$eoms->year-$eoms->month-20")) ?> End of Month Summary</h4>
            </div>
            <div class="panel dashboard-last-eoms-content">
                <div class='dashboard-last-eoms-required dashboard-last-eoms-field'>
                    <div class='dashboard-last-eoms-label'>Required Amount</div>
                    <div class='dashboard-last-eoms-value'><?= Formatter::currency($ccAmount + $nextMonthsEverydayAmount +  $remainingJarAmount) ?></div>
                </div>
                <div class='dashboard-last-eoms-cc dashboard-last-eoms-field'>
                    <div class='dashboard-last-eoms-label'>Credit Card</div>
                    <div class='dashboard-last-eoms-value'><?= Formatter::currency($ccAmount) ?></div>
                </div>
                <div class='dashboard-last-eoms-everyday dashboard-last-eoms-field'>
                    <div class='dashboard-last-eoms-label'>Everyday Expenses</div>
                    <div class='dashboard-last-eoms-value'><?= Formatter::currency($nextMonthsEverydayAmount) ?></div>
                </div>
                <div class='dashboard-last-eoms-remaining dashboard-last-eoms-field'>
                    <div class='dashboard-last-eoms-label'>Funds Remaining</div>
                    <div class='dashboard-last-eoms-value'><?= Formatter::currency($remainingJarAmount) ?></div>
                </div>
                <div class='dashboard-last-eoms-bank dashboard-last-eoms-field'>
                    <div class='dashboard-last-eoms-label'>Bank Balance</div>
                    <div class='dashboard-last-eoms-value'><?= Formatter::currency($accountsEomsBalance) ?></div>
                </div>
                <div class='dashboard-last-eoms-total dashboard-last-eoms-field'>
                    <?php
                        if (0 > $equationResult) {
                            $eomsTotalLabel = 'Deficit';
                            $eomsTotalCls = 'gj-is-negative';
                        } else {
                            $eomsTotalLabel = 'Surplus';
                            $eomsTotalCls = '';
                        }
                    ?>
                    <div class='dashboard-last-eoms-label'><?= $eomsTotalLabel ?></div>
                    <div class='dashboard-last-eoms-value <?= $eomsTotalCls ?>'><?= Formatter::currency($equationResult) ?></div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>

    <div class="row dashboard-jars">
        <div class="col-md-12">
            <h4>Jars</h4>
        <div>
        <div class="panel col-md-12 dashboard-jars-carousel">
            <div class='dashboard-jars-scroll dashboard-jars-scroll-left'>
                <i class="glyphicon glyphicon-triangle-left"></i>
            </div>
            <div class='dashboard-jars-carousel-wrapper'>
                <?php /** @var Jar $j */ foreach ($jars as $j) { ?>
                    <a class='dashboard-jars-jar' href="/jars/expense-jar-detail?id=<?= $j->id ?>">
                        <div class='dashboard-jars-jar-icon'>
                            <img src="/imgs/jar.svg" width="30" alt="Jar Icon">
                        </div>
                        <div class='dashboard-jars-jar-name'><?= $j->name ?></div>
                        <div class='dashboard-jars-jar-spent'>
                            <div class='dashboard-jars-jar-spent-amount'>
                                <?= Formatter::currency($j->getThisMonthsTransactionsAmount()) ?>
                            </div>
                            <div class='dashboard-jars-jar-spent-label'>
                                Amount Spent
                            </div>
                        </div>
                        <div class='dashboard-jars-jar-remaining'>
                            <div class='dashboard-jars-jar-remaining-amount'>
                                <?= Formatter::currency($j->getThisMonthsFundsRemainingAmount()) ?>
                            </div>
                            <div class='dashboard-jars-jar-remaining-label'>
                                Funds Remaining
                            </div>
                        </div>
                    </a>
                <?php } ?>
            </div>
            <div class='dashboard-jars-scroll dashboard-jars-scroll-right active'>
                <i class="glyphicon glyphicon-triangle-right"></i>
            </div>
        </div>
    </div>

    <div class="row dashboard-upcoming-expenses">
        <div class="col-md-12">
            <h4>Upcoming Expenses</h4>
        </div>
        <div class="col-md-12">
        <?php if (count($upcomingExpenses)) { ?>
            <?php foreach ($upcomingExpenses as $e) { ?>
                <div class="col-md-16 panel dashboard-upcoming-expense">
                    <div class='dashboard-upcoming-expense-days'>
                        <?= Calculator::getRelativeTime($e->date, true) ?>
                    </div>
                    <div class='dashboard-upcoming-expense-amount'>
                        <?= Formatter::currency($e->amount) ?>
                    </div>
                    <div class='dashboard-upcoming-expense-name'><?= $e->name ?></div>
                    <div class='dashboard-upcoming-expense-jar'>
                        in
                        <a href='/jars/expense-jar-detail?id=<?= $e->jar->id ?>'><?= $e->jar->name ?></a>
                    </div>
                </div>
            <?php } ?>
        <?php } else { ?>
            No upcoming expenses yet!
        <?php } ?>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>
