<?php
use backend\models\db\Account;
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;
use backend\components\helpers\JsTools;
use backend\widgets\Tooltip;
use backend\widgets\VideoTutorial;
?>

<div id="body" class="eoms-summary-edit container-fluid<?= ($thisMonthsEoms) ? ' this-months-eoms' : '' ?>" data-js-callback="budgetEomSummaryLoaded" data-select-menu="li#budgeting-tools-eom-summary" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <?= VideoTutorial::widget([
        'type' => Yii::$app->session->get('eomsOverdue') ? 'eoms-locked' : 'eoms'
    ]) ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head eoms-date-selector" data-js-callback="eomsDetailForDate" data-js-callback-months="eomsMonths">
                <h3>
                    End of Month Summary
                    <?php if (Yii::$app->session->get('eomsOverdue')) { ?>
                    - <?= $monthName . ' ' . $year ?>
                </h3>
                    <?php } else { ?>
                </h3>
                <select class="selectpicker" name="month">
                    <?php foreach ($months as $value => $m) { ?>
                    <option value="<?= $value ?>"<?= ($value == $month) ? ' selected="selected"' : ''; ?>><?= $m ?></option>
                    <?php } ?>
                </select>
                <select class="selectpicker" name="year">
                    <?php foreach ($years as $value => $y) { ?>
                    <option value="<?= $value ?>"<?= ($value == $year) ? ' selected="selected"' : ''; ?>><?= $y ?></option>
                    <?php } ?>
                </select>
                <?php } ?>
            </div>
        </div>
    </div>
    <section>
        <div class="row">
            <div class="col-md-12">
                <h4>
                    Adjust Bank Account Balances
                    <?=
                        Tooltip::widget(['text' => 'To keep your Budget aligned with the reality of your bank accounts at the end of each month you need to update Grandma’s Jars with the actual balance of your Bank Accounts.']);
                    ?>

                </h4>
                <p>Match your Account Balances to your real world balances at the end of this month.</p>
            </div>
        </div>

        <?php $form = ActiveForm::begin(['id' => 'eoms-form']); ?>
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-table eoms-accounts">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Account Type</th>
                                <th>
                                    Current Balance in Budget
                                    <?= Tooltip::widget(['text' => 'Current Balance is the Bank account Balance currently recorded in Grandma’s Jars based on ‘Last months Balance’ and the transactions that have been entered into Grandma’s Jars throughout the month.']); ?>
                                </th>
                                <th>
                                    Adjustment Amount
                                    <?= Tooltip::widget(['text' => 'This is the amount you have manually adjusted to reconcile what you actually have in your account and what is reflected by the transactions you have put in over the past month.']) ?>
                                </th>
                                <th>
                                    Actual Balance in Bank
                                    <?= Tooltip::widget(['text' => 'The ‘Actual Balance’ is the balance showing on your bank account on the very last day of the month. This is what you really have in your bank account, importantly it has to be the last day.']); ?>
                                </th>
                                <th>
                                    Amount to Use for Summary
                                    <?= Tooltip::widget(['text' => 'The ‘Amount to use for summary’ is how much of the account balance is used towards your end of month summary calculation (EOMS). If this does not make sense please watch the video tutorial again and register for our monthly EOMS webinar.']); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (count($accounts) > 0) { ?>
                            <?php /** @var Account $a */
                                foreach ($accounts as $a) { ?>
                            <tr<?= $aForm->archived[$a->id] ? ' class="danger"' : '' ?>>
                                <td>
                                    <?= $a->name ?>
                                    <?= $aForm->archived[$a->id] ?
                                        Tooltip::widget(['text' => 'This account is now deleted and it will not show up on the next EoMS.']) : '' ?>
                                </td>
                                <td><?= $a->accountType->name ?></td>
                                <td><?= Formatter::currency($aForm->current_balance[$a->id]) ?></td>
                                <td><?= Formatter::currency($aForm->adjustment_amount[$a->id]) ?></td>
                                <td>
                                    <?=
                                    $form->field($aForm, 'balance[' . $a->id . ']', [
                                        'template' => "{input}\n<span class=\"form-control-feedback\" aria-hidden=\"true\">" . Formatter::getCurrencySign() . "</span>\n{hint}\n{error}",
                                        'options' => [
                                            'class' => 'form-group has-feedback'
                                        ]
                                    ])->textInput([
                                        'value' => Formatter::currency($aForm->balance[$a->id], 'none'),
                                        'disabled' => $equationResult ? true : false
                                    ])->label('');
                                    ?>
                                </td>
                                <td>
                                    <?=
                                    $form->field($aForm, 'summary_balance[' . $a->id . ']', [
                                        'template' => "{input}\n<span class=\"form-control-feedback\" aria-hidden=\"true\">" . Formatter::getCurrencySign() . "</span>\n{hint}\n{error}",
                                        'options' => [
                                            'class' => 'form-group has-feedback'
                                        ]
                                    ])->textInput([
                                        'value' => Formatter::currency($aForm->summary_balance[$a->id], 'none'),
                                        'disabled' => $equationResult ? true : false
                                    ])->label('');
                                    ?>
                                </td>
                            </tr>
                            <?php } ?>
                            <?php } else { ?>
                            <tr>
                                <td colspan="6">
                                    <p>No accounts.</p>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <h4>
                    Adjust Credit Card Balances
                    <?=
                        Tooltip::widget(['text' => 'To keep your Budget aligned with the reality of your credit card balance at the end of each month you need to update Grandma’s Jars with the actual balance owing (or in credit) on your Credit card(s).']);
                    ?>
                </h4>
                <p>Your Credit Card balances also need to be up to date so we can calculate your spending on them this month.</p>
                <div class="pay-off-options mb20">
                    <div class="radio-inline">
                        <?= Html::radio(
                            'pay-off-option',
                            $eoms && $eoms->cc_pay_off_option == \backend\models\db\Eoms::CC_PAY_OFF_EVERY_MONTH,
                            [
                                'id' => 'pay-off-2',
                                'value' => \backend\models\db\Eoms::CC_PAY_OFF_EVERY_MONTH,
                                'disabled' => $equationResult ? true : false
                            ]
                        ); ?>
                        <?= Html::label('I pay off my credit cards every month', 'pay-off-2'); ?>
                    </div>
                    <div class="radio-inline">
                        <?= Html::radio(
                            'pay-off-option',
                            $eoms && $eoms->cc_pay_off_option == \backend\models\db\Eoms::CC_PAY_OFF_NOT_EVERY_MONTH,
                            [
                                'id' => 'pay-off-1',
                                'value' => \backend\models\db\Eoms::CC_PAY_OFF_NOT_EVERY_MONTH,
                                'disabled' => $equationResult ? true : false
                            ]
                        ); ?>
                        <?= Html::label('I don\'t pay off my credit cards every month', 'pay-off-1'); ?>
                    </div>
                </div>
                <div class="panel panel-table eoms-cc-debts">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th></th>
                                <th>
                                    Starting Balance
                                    <?=
                                    Tooltip::widget(['text' => 'Starting Balance tooltip']);
                                    ?>
                                </th>
                                <th>
                                    Money Paid Off
                                    <?= Tooltip::widget(['text' => 'This is the amount of money you have put towards your credit card balance this month.']); ?>
                                </th>
                                <th>
                                    Money Spent
                                    <?= Tooltip::widget(['text' => 'This month’s spending is the difference between ‘Last month’s Balance’ and ‘Actual Balance’- This Month’s Spending is an automatic calculation performed by Grandmas’ Jars.']); ?>
                                </th>
                                <th>
                                    Current Balance
                                    <?= Tooltip::widget(['text' => 'Current Balance is the Credit card Balance currently recorded in Grandma’s Jars based on ‘Last month’s Balance’ and the transactions that have been entered into Grandma’s Jars throughout the month.']); ?>
                                </th>
                                <th>
                                    Adjustment Amount
                                    <?= Tooltip::widget(['text' => 'This is the amount you have manually adjusted to reconcile what you actually have on your credit card and what is reflected by the transactions you have put in over the past month.']); ?>
                                </th>
                                <th>
                                    Actual Balance
                                    <?= Tooltip::widget(['text' => 'The ‘Actual Balance’ is the balance showing on your credit card on the very last day of the month. This is what you really owe, importantly it has to be the last day.']); ?>
                                    <br/>
                                    <em>Money owing on your CC should be entered as a negative value</em>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (count($ccDebts) > 0) { ?>
                            <?php foreach ($ccDebts as $key => $c) { ?>
                            <tr<?= $cForm->archived[$key] ? ' class="danger"' : '' ?>>
                                <td>
                                    <?= $c->name ?>
                                    <?= $cForm->archived[$key] ?
                                        Tooltip::widget(['text' => 'This credit card is now deleted and it will not show up on the next EoMS.']) : '' ?>
                                </td>
                                <td><?= Formatter::currency($cForm->starting_balance[$key]) ?></td>
                                <td><?= Formatter::currency($cForm->payments_made[$key]) ?></td>
                                <td><?= Formatter::currency($cForm->money_spent[$key]) ?></td>
                                <td>
                                    <?= Formatter::currency($cForm->current_balance[$key]) ?>
                                    <?= $form->field($cForm, 'current_balance[' . $key . ']', [
                                        'options' => ['class' => 'hidden']
                                    ])->hiddenInput() ?>
                                </td>
                                <td><?= Formatter::currency($cForm->adjustment_amount[$key]) ?></td>
                                <td class="cc-debt-amount" data-init-value="<?= $cForm->actual_balance[$key] ?>">
                                    <?=
                                    $form->field($cForm, 'actual_balance[' . $key . ']', [
                                        'template' => "{input}\n<span class=\"form-control-feedback\" aria-hidden=\"true\">" . Formatter::getCurrencySign() . "</span>\n{hint}\n{error}",
                                        'options' => [
                                            'class' => 'form-group has-feedback'
                                        ]
                                    ])->textInput([
                                        'value' => Formatter::currency($cForm->actual_balance[$key], 'none'),
                                        'disabled' => $equationResult ? true : false
                                    ])->label('');
                                    ?>
                                </td>
                            </tr>
                            <?php } ?>
                            <?php } else { ?>
                            <tr>
                                <td colspan="7">
                                    <p>No credit cards.</p>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <hr/>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <h4 class="no-mt">
                    Adjust Debt Balances
                    <?=
                        Tooltip::widget(['text' => 'Adjust Debt balances is where you can update your debt balances at the end of each month to help you measure your progress']);
                    ?>
                </h4>
                <p>Match your Debt Balances to your real world balances at the end of this month.</p>
                <div class="panel panel-table eoms-debt-balances">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Type of Debt</th>
                                <th>
                                    Current Balance
                                    <?= Tooltip::widget(['text' => 'Current Balance is the Balance owing on each of your debts as the end of the last month.']); ?>
                                </th>
                                <th>
                                    Adjustment Amount
                                    <?= Tooltip::widget(['text' => 'This is the amount you have manually adjusted to reconcile what you actually have on your debt and what is reflected by the payments you have put in over the past month.']) ?>
                                </th>
                                <th>
                                    Actual Balance
                                    <?= Tooltip::widget(['text' => 'Actual Balance is the Balance owing on your debt as shown on you bank statements at the last day of this most recent month.']); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (count($debts) > 0) { ?>
                            <?php foreach ($debts as $d) { ?>
                            <tr<?= $dForm->archived[$d->id] ? ' class="danger"' : '' ?>>
                                <td>
                                    <?= $d->name ?>
                                    <?= $dForm->archived[$d->id] ?
                                        Tooltip::widget(['text' => 'This debt is now deleted and it will not show up on the next EoMS.']) : '' ?>
                                </td>
                                <td><?= $d->debtType->name ?></td>
                                <td><?= Formatter::currency($dForm->current_amount[$d->id]) ?></td>
                                <td><?= Formatter::currency($dForm->adjustment_amount[$d->id]) ?></td>
                                <td>
                                    <?=
                                    $form->field($dForm, 'amount[' . $d->id . ']', [
                                        'template' => "{input}\n<span class=\"form-control-feedback\" aria-hidden=\"true\">" . Formatter::getCurrencySign() . "</span>\n{hint}\n{error}",
                                        'options' => [
                                            'class' => 'form-group has-feedback'
                                        ]
                                    ])->textInput([
                                        'value' => Formatter::currency($dForm->amount[$d->id], 'none'),
                                        'disabled' => $equationResult ? true : false
                                    ])->label('');
                                    ?>
                                </td>
                            </tr>
                            <?php } ?>
                            <?php } else { ?>
                            <tr>
                                <td colspan="5">
                                    <p>No debts.</p>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <?php if (!isset($equationResult)) { ?>
                <div class="clearfix">
                    <?= Html::submitButton('Submit Balances', ['class' => 'btn btn-primary pull-right', 'data-js-callback' => 'balancesSubmitted']) ?>
                </div>
                <?php } ?>

            </div>
        </div>
        <?php ActiveForm::end(); ?>
    </section>

    <section id="eom-step2"<?php if (!isset($equationResult)) { ?> class="hidden"<?php } ?>>
        <?php $form = ActiveForm::begin(['id' => 'eoms2-form']); ?>
        <div class="row">
            <div class="col-md-12">
                <?= $this->render('_end-of-month-summary-calculation', [
                    'accountsEomsBalance' => isset($accountsEomsBalance) ? $accountsEomsBalance : 0,
                    'ccDebtTransactionsAmount' => isset($ccDebtTransactionsAmount) ? $ccDebtTransactionsAmount : 0,
                    'ccActualBalanceTotal' => isset($ccActualBalanceTotal) ? $ccActualBalanceTotal : 0,
                    'nextMonthsEverydayAmount' => isset($nextMonthsEverydayAmount) ? $nextMonthsEverydayAmount : 0,
                    'remainingJarAmount' => isset($remainingJarAmount) ? $remainingJarAmount : 0,
                    'equationResult' => isset($equationResult) ? $equationResult : 0,
                    'eoms' => $eoms,
                    'form' => $form,
                    'eForm' => $eForm,
                    'editable' => true
                ]); ?>

                <?php /*
                <div class="panel panel-table budget-selectors">
                    <div class="clearfix title">
                        <div class="pull-left">Drag the sliders to select how much you want to allocate to each of your goals.</div>
                        <div class="pull-right">Surplus to Allocate<span class="ml"> $0/2,198.00</span></div>
                    </div>
                    <div class="item">
                        <div class="row">
                            <div class="col-sm-4 desc">Debt Snowball</div>
                            <div class="col-sm-5">
                                <div class="row">
                                    <div class="col-sm-4">
                                        $200.00<span class="off">/400.00</span>
                                    </div>
                                    <div class="col-sm-8">
                                        <input class="slider" data-slider-id='ex1Slider' type="text" data-slider-min="0" data-slider-max="400" data-slider-step="10" data-slider-value="200"/>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group has-feedback">
                                    <input type="text" class="form-control">
                                    <span class="form-control-feedback" aria-hidden="true"><?= Formatter::getCurrencySign(); ?></span>
                                </div>
                            </div>
                            <div class="col-sm-1 text-right">40%</div>
                        </div>
                    </div>
                    <div class="item">
                        <div class="row">
                            <div class="col-sm-4 desc">Holiday</div>
                            <div class="col-sm-5">
                                <div class="row">
                                    <div class="col-sm-4">
                                        $5,000.00<span class="off">/40,000.00</span>
                                    </div>
                                    <div class="col-sm-8">
                                        <input class="slider" data-slider-id='ex1Slider' type="text" data-slider-min="0" data-slider-max="40000" data-slider-step="10" data-slider-value="5000"/>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group has-feedback">
                                    <input type="text" class="form-control">
                                    <span class="form-control-feedback" aria-hidden="true"><?= Formatter::getCurrencySign(); ?></span>
                                </div>
                            </div>
                            <div class="col-sm-1 text-right">40%</div>
                        </div>
                    </div>
                    <div class="item">
                        <div class="row">
                            <div class="col-sm-4 desc">Buy a New Car</div>
                            <div class="col-sm-5">
                                <div class="row">
                                    <div class="col-sm-4">
                                        -$20,000.00
                                    </div>
                                    <div class="col-sm-8">
                                        <input class="slider" data-slider-id='ex1Slider' type="text" data-slider-min="0" data-slider-max="20000" data-slider-step="10" data-slider-value="2000"/>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group has-feedback">
                                    <input type="text" class="form-control">
                                    <span class="form-control-feedback" aria-hidden="true"><?= Formatter::getCurrencySign(); ?></span>
                                </div>
                            </div>
                            <div class="col-sm-1 text-right">40%</div>
                        </div>
                    </div>
                </div>
                */ ?>
                <div class="clearfix">
                    <div class="pull-right">
                        <?= Html::submitButton('Submit Summary', [
                            'class' => 'btn btn-primary pull-right',
                            'data-js-callback' => 'eomsSubmitted',
                            'data-submit-url' => Url::toRoute('/budget/end-of-month-summary-submit')
                        ]) ?>
                    </div>
                    <div class="pull-right">
                        <?= Html::a('Start Over', ['/budget/start-over'], [
                            'class' => 'btn btn-danger pull-right system-link mr'
                        ]) ?>
                    </div>
                </div>
            </div>
        </div>
        <?php ActiveForm::end(); ?>
        <?= JsTools::viewJs($this); ?>
    </section>

    <?= $this->render('/layouts/_footer') ?>

</div>
