<?php
use backend\components\helpers\Formatter;
use backend\models\db\Debt;
use backend\models\db\Expense;
use yii\helpers\Html;

/** @var Expense $expense */
?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<div class="modal-body">
    <?php if (!empty($expenses)) { ?>
    <h4>Expenses</h4>
    <table class="table">
        <thead>
        <tr>
            <th>Expense</th>
            <th>Budgeted</th>
            <th>Actual</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($expenses as $expense) { ?>
        <tr>
            <td><?= $expense->name ?></td>
            <td><?= Formatter::currency($expense->getAverageMonthlyAmount($month, $year)) ?></td>
            <td><?= Formatter::currency($expense instanceof Debt ? $expense->getMonthsDebtPaymentsAmount($month, $year) : $expense->getMonthsTransactionsAmount($month, $year)) ?></td>
        </tr>
        <?php } ?>
        <?php if ($unbudgeted) { ?>
        <tr>
            <td><em>Unbudgeted</em></td>
            <td><?= Formatter::currency(0) ?></td>
            <td><?= Formatter::currency($unbudgeted) ?></td>
        </tr>
        <?php } ?>
        </tbody>
    </table>
    <hr/>
    <?php } ?>

    <?php if ($budgeted) { ?>
    <h4>Totals</h4>
    <table class="table">
        <thead>
        <tr>
            <th>Budgeted</th>
            <th>Spent</th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td><?= Formatter::currency($budgeted) ?></td>
            <td><?= Formatter::currency($spent) ?></td>
        </tr>
        </tbody>
    </table>
    <hr/>
    <?php } ?>

    <p>
        Total Adjustment: <strong><?= Formatter::currency(
            $jarFundsRemainingAdjustment !== null ? $jarFundsRemainingAdjustment : 0
        ) ?></strong>
    </p>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
</div>