<?php
use backend\models\db\Jar;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;
use yii\bootstrap\ButtonDropdown;
use yii\helpers\Url;
use backend\widgets\VideoTutorial;

//data-js-callback="budgetEomSummaryLoaded"
?>

<div id="body" class="container-fluid" data-js-callback="bodyLoaded" data-select-menu="li#budgeting-tools-jar-summary" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <?= VideoTutorial::widget(['type' => 'jar-summary']) ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3><?= $this->title ?></h3>
                <?= ButtonDropdown::widget([
                    'label' => $year,
                    'dropdown' => [
                        'items' => $years,
                    ]
                ]); ?>
                <?= ButtonDropdown::widget([
                    'label' => $month,
                    'dropdown' => [
                        'items' => $months,
                    ]
                ]); ?>
                <?= ButtonDropdown::widget([
                    'label' => $jarName,
                    'dropdown' => [
                        'items' => $allJars,
                    ]
                ]); ?>
            </div>
        </div>
    </div>

    <?php if ($jarId) { ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h4>Viewing <?= $jarName ?> for <?= $year ?></h4>
            </div>
            <div class="panel panel-table">
                <table class="table table-bordered">
                    <thead class="color-2">
                    <tr>
                        <th>Month</th>
                        <th>Accumulated Funds</th>
                        <th>Monthly Budget</th>
                        <th>Amount Spent</th>
                        <th>Money In</th>
                        <th>Funds Remaining</th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($jarSummary as $j) {
                        $accumulatedCls = ($j['brought_forward'] >= 0) ? '' : 'gj-is-negative';
                        $remainingCls = ($j['funds_remaining'] >= 0) ? '' : 'gj-is-negative';
                    ?>
                    <tr>
                        <td><?= $j['month'] ?></td>
                        <td class='<?= $accumulatedCls ?>'><?= Formatter::currency($j['brought_forward']) ?></td>
                        <td><?= Formatter::currency($j['monthly_budget']) ?></td>
                        <td><?= Formatter::currency($j['amount_spent']) ?></td>
                        <td><?= Formatter::currency($j['money_in']) ?></td>
                        <td class='<?= $remainingCls ?>'><?= Formatter::currency($j['funds_remaining']) ?></td>
                        <td>
                            <?php if ($j['jar']->isAfterFirstEoms($j['month_int'], $j['year'])) { ?>
                            <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute([
                                '/budget/adjust-jar-funds-remaining',
                                'jar_id' => $jarId,
                                'month'  => $j['month_int'],
                                'year'   => $year
                            ]) ?>">
                                <i class="glyphicon glyphicon-edit"></i>
                            </a>
                            <?php } ?>
                            <a href="#" class="open-modal" data-modal-url="<?= Url::to([
                                '/budget/jar-summary-tooltip',
                                'jar_id' => $jarId,
                                'month'  => $j['month_int'],
                                'year'   => $year
                            ]) ?>">
                                <i class="glyphicon glyphicon-zoom-in"></i>
                            </a>
                            <?php if ($j['funds_remaining_adjustment'] !== null) { ?>
                            <a href="#" data-toggle="tooltip" data-placement="auto" title="Funds remaining adjustment: <?= Formatter::currency($j['funds_remaining_adjustment']) ?>" onclick="return false">
                                <i class="glyphicon glyphicon-ok pull-right"></i>
                            </a>
                            <?php } ?>
                        </td>
                    </tr>
                    <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php } else { ?>
    <div class="row">
        <div class="col-md-12">
            <p>Please select a jar from the list above.</p>
        </div>
    </div>
    <?php } ?>

    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h4><?= $currentMonth ? 'Current ' : '' ?>Month Summary (<?= $month . ' ' . $year ?>)</h4>
            </div>
            <div class="panel panel-table">
                <table class="table table-bordered">
                    <thead class="color-2">
                    <tr>
                        <th>Jar</th>
                        <th>Accumulated Funds</th>
                        <th>Monthly Budget</th>
                        <th>Amount Spent</th>
                        <th>Money In</th>
                        <th>Funds Remaining</th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $totalBrought = 0;
                    $totalBudget  = 0;
                    $totalTrans   = 0;
                    $totalMoneyIn = 0;
                    $totalRemain  = 0;
                    $totalCorrect = 0;
                    /** @var Jar $j */
                    foreach ($jars as $j) {
                        $brought = $j->getMonthsFundsBroughtForwardAmount($monthInt, $year);
                        $budget  = $j->getMonthlyBudget($monthInt, $year);
                        $trans   = $j->getMonthsTransactionsAmount($monthInt, $year, false, false);
                        $moneyIn = $j->getMonthsMoneyInAmount($monthInt, $year, false, false);
                        $remain  = $j->getMonthsFundsRemainingAmount($monthInt, $year);
                        $adjust  = $j->getFundsRemainingAdjustment($monthInt, $year);
                        $totalBrought += $brought;
                        $totalBudget  += $budget;
                        $totalTrans   += $trans;
                        $totalMoneyIn += $moneyIn;
                        $totalRemain  += $remain;
                        $totalCorrect += $remain > 0 ? $remain : 0;
                        $accumulatedCls = ($brought >= 0) ? '' : 'gj-is-negative';
                        $remainingCls = ($remain >= 0) ? '' : 'gj-is-negative';
                        ?>
                        <tr>
                            <td><?= $j->name ?></td>
                            <td class='<?= $accumulatedCls ?>'><?= Formatter::currency($brought) ?></td>
                            <td><?= Formatter::currency($budget) ?></td>
                            <td><?= Formatter::currency($trans) ?></td>
                            <td><?= Formatter::currency($moneyIn) ?></td>
                            <td class='<?= $remainingCls ?>'><?= Formatter::currency($remain) ?></td>
                            <td>
                                <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute([
                                    '/budget/adjust-jar-funds-remaining',
                                    'jar_id' => $j->id,
                                    'month'  => $monthInt,
                                    'year'   => $year
                                ]) ?>">
                                    <i class="glyphicon glyphicon-edit"></i>
                                </a>
                                <a href="#" class="open-modal" data-modal-url="<?= Url::to([
                                    '/budget/jar-summary-tooltip',
                                    'jar_id' => $j->id,
                                    'month'  => $monthInt,
                                    'year'   => $year
                                ]) ?>">
                                    <i class="glyphicon glyphicon-zoom-in"></i>
                                </a>
                                <?php if ($adjust !== null) { ?>
                                <a href="#" data-toggle="tooltip" data-placement="auto" title="Funds remaining adjustment: <?= Formatter::currency($adjust) ?>" onclick="return false">
                                    <i class="glyphicon glyphicon-ok pull-right"></i>
                                </a>
                                <?php } ?>
                            </td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="col-md-12">
            <div class="well">
                <div class="row">
                    <div class="col-md-6">
                        <dl class="dl-horizontal">
                            <dt>Total Accumulated Funds</dt>
                            <dd><?= Formatter::currency($totalBrought) ?></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Total Monthly Budget</dt>
                            <dd><?= Formatter::currency($totalBudget) ?></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Total Amount Spent</dt>
                            <dd><?= Formatter::currency($totalTrans) ?></dd>
                        </dl>
                    </div>
                    <div class="col-md-6">
                        <dl class="dl-horizontal">
                            <dt>Total Money In</dt>
                            <dd><?= Formatter::currency($totalMoneyIn) ?></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Total Actual Balance</dt>
                            <dd><?= Formatter::currency($totalRemain) ?></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Total Corrected Balance</dt>
                            <dd><?= Formatter::currency($totalCorrect) ?></dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>