<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Frequencies;
use backend\components\helpers\Formatter;
use backend\widgets\VideoTutorial;
?>

<div id="body" class="container-fluid" data-js-callback="positionSummaryLoaded" data-select-menu="li#budgeting-tools-position-summary" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <?= VideoTutorial::widget(['type' => 'position-summary']) ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3>Position Summary</h3>
            </div>
        </div>
    </div>

    <div class="row jar-header-info">
        <div class="col-50">
            <div class="item-value">
                <div class="value"><?= Formatter::currency($minMonthlyIncome) ?></div>
                <div class="desc">Minimum Monthly Income</div>
            </div>
        </div>
        <div class="col-50">
            <div class="item-value">
                <div class="value"><?= Formatter::currency($avgMonthlyIncome) ?></div>
                <div class="desc">Average Monthly Income</div>
            </div>
        </div>
        <div class="col-50">
            <div class="item-value">
                <div class="value"><?= Formatter::currency($totalMonthlyBudget) ?></div>
                <div class="desc">Monthly Jar Allocation</div>
            </div>
        </div>
        <div class="col-50">
            <div class="item-value">
                <div class="value<?= ($minMonthlySurplus >= 0) ? ' text-success' : ' value-red'; ?>"><?= Formatter::currency($minMonthlySurplus) ?></div>
                <div class="desc">Minimum Monthly <?= $minMonthlySurplus >= 0 ? 'Surplus' : 'Deficit' ?></div>
            </div>
        </div>
        <div class="col-50">
            <div class="item-value">
                <div class="value<?= ($avgMonthlySurplus >= 0) ? ' text-success' : ' value-red'; ?>"><?= Formatter::currency($avgMonthlySurplus) ?></div>
                <div class="desc">Average Monthly <?= $avgMonthlySurplus >= 0 ? 'Surplus' : 'Deficit' ?></div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <div class="col-head">
                <h4>Monthly Income</h4>
            </div>
            <div class="panel panel-table">
                <?= $this->render('_monthly-income-table', [
                    'minMonthlyIncome'  => $minMonthlyIncome,
                    'avgMonthlyIncome'  => $avgMonthlyIncome
                ]); ?>
            </div>

            <div class="panel panel-tabbed">
                <div class="tabpanel">
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="active"><a href="#monthly-income" aria-controls="home" role="tab" data-toggle="tab">Monthly Income</a></li>
                        <li role="presentation"><a href="#jar-allocations" aria-controls="profile" role="tab" data-toggle="tab">Jar Allocations</a></li>
                        <li role="presentation"><a href="#compare" aria-controls="profile" role="tab" data-toggle="tab">Compare Income to Outgoings</a></li>
                    </ul>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane data-graph static-graph panel-paged active" id="monthly-income" data-ajax="<?= Url::toRoute(['/budget/monthly-income-graph-data']) ?>">
                            <div class="ct-chart"></div>
                        </div>
                        <div role="tabpanel" class="tab-pane data-graph static-graph panel-paged" id="jar-allocations" data-ajax="<?= Url::toRoute(['/budget/jar-allocations-graph-data']) ?>">
                            <div class="ct-chart"></div>
                        </div>
                        <div role="tabpanel" class="tab-pane data-graph static-graph panel-paged" id="compare" data-ajax="<?= Url::toRoute(['/budget/compare-graph-data']) ?>">
                            <div class="ct-chart"></div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="col-sm-6">
            <div class="col-head">
                <h4>Monthly Jar Allocations</h4>
            </div>
            <div class="panel panel-table">
                <?= $this->render('_monthly-jar-allocations',[
                    'totalMonthlyBudget' => $totalMonthlyBudget
                ]); ?>
            </div>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>


