<?php
use backend\components\helpers\Calculator;
use backend\components\helpers\Formatter;
use dosamigos\datetimepicker\DateTimePicker;
use dosamigos\typeahead\TypeAhead;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>

<?php $form = ActiveForm::begin([
    'id' => 'confirm-action-form'
]); ?>
<div class="modal-body">

    <div class="message"></div>

    <div class="row">
        <div class="col-md-12">
            <p>Are you sure you want to cancel this appointment (<strong><?= $bookingDate ?></strong>)?</p>
        </div>
    </div>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']); ?>
    <?= Html::submitButton('Cancel appointment', [
        'class' => 'btn btn-primary ajax-submit',
        'data-js-callback' => 'reloadAppointmentsDay',
        'data-submit-url' => Url::toRoute(['/coach/cancel-booking', 'id' => $booking->id, 'confirm' => 1])
    ]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>


