<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;
use backend\widgets\VideoTutorial;

$bookingUrl = Url::toRoute(['/coach/add-booking']);
?>
<div id="body" class="container-fluid" data-js-callback="messagingLoaded" data-select-menu=".panel.coach" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <?= VideoTutorial::widget() ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3><?= Html::encode($title) ?></h3>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <h4>Your Coach</h4>
        </div>
    </div>

    <div class="row coach-profile">
        <div class="col-sm-6">
            <div class="user-profile clearfix">
                <div class="avatar">
                    <img src="<?= $coach->getAvatarUrl() ?>" alt="coach avatar"/>
                </div>
                <div class="info">
                    <div class="username"><?= $coach->fullName ?></div>
                    <div>Budgeting Coach</div>
                    <div class="loc">
                        <?php if ($coach->id == Yii::$app->params['defaultCoachId']) {
                            echo '<strong>' . Html::a('How do I get a coach?', ['/faq#faq_10']) . '</strong>';
                        }
                        else {
                            echo isset($coachMeta['address_line_1']) && (strlen($coachMeta['address_line_1']) > 0) ? '<div>' . $coachMeta['address_line_1'] . '</div>' : '';
                            echo isset($coachMeta['address_line_2']) && (strlen($coachMeta['address_line_2']) > 0) ? '<div>' . $coachMeta['address_line_2'] . '</div>' : '';
                            echo isset($coachMeta['address_line_3']) && (strlen($coachMeta['address_line_3']) > 0) ? '<div>' . $coachMeta['address_line_3'] . '</div>' : '';
                        } ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="item-value">
                <div class="value"><?= $coachTime; ?></div>
                <div class="desc">Coaches Current Time</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="item-value">
                <div class="value next-appointment-date"><?= $nextAppointment ?></div>
                <div class="desc">Next Appointment</div>
            </div>
        </div>
    </div>

    <div class="row appointments mb40">
        <div class="col-md-6">
            <div class="row mb10">
                <div class="col-md-12">
                    <div class="col-head">
                        <h4>Appointments</h4>
                        <?php /*<a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/appointments/add-appointment']) ?>">Add Appointment</a>*/ ?>
                    </div>
                </div>
            </div>
            <?= yii2fullcalendar\yii2fullcalendar::widget([
                'id' => 'slots-summary',
                'header' => [
                    'left' => 'prev,next today',
                    'right' => 'title',
                    //'right' => 'month,agendaWeek,agendaDay,listWeek'
                ],
                'defaultView' => 'listWeek',
                'ajaxEvents' => Url::to(['/coach/bookings'])
            ]); ?>
        </div>
        <div class="col-md-6">
            <div class="row mb10">
                <div class="col-md-12">
                    <div class="col-head">
                        <h4>Book new appointment</h4>
                    </div>
                </div>
            </div>
            <?php if (!$user->canBookAppointment()) { ?>
            <p class="text-center text-danger">You already have a booked appointment. You cannot book any new appointments.</p>
            <?php } ?>
            <?= yii2fullcalendar\yii2fullcalendar::widget([
                'id' => 'slots-calendar',
                'header' => [
                    'left' => 'prev,next today',
                    'center' => 'title',
                    'right' => 'agendaWeek,agendaDay'
                ],
                'defaultView' => 'agendaWeek',
                'select' => new \yii\web\JsExpression("function(start, end) { openModal('{$bookingUrl}?start=' + start + '&end=' + end); }"),
                'eventClick' => new \yii\web\JsExpression("function(event, jsEvent, view) { openModal('{$bookingUrl}?id=' + event.id); }"),
                'ajaxEvents' => Url::to(['/coach/events']),
                'clientOptions' => [
                    'selectable' => $user->canBookAppointment(),
                ]
            ]); ?>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>
<?php
$submitUrl = Url::to(['send-message']);
$this->js['messages'][] = <<<EOS
        $('#sendMessage').on('click', function () {
            $.post('$submitUrl', {
                message: $('#newMessage').val()
            });
        });
EOS;
?>
<?= \backend\components\helpers\JsTools::viewJs($this) ?>
