<?php

use backend\models\db\User;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;
use backend\components\helpers\JsTools;

?>
<div id="body" class="container-fluid" data-js-callback="messagingLoaded" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">

    <div class="col-head">
        <h3>Messages</h3>
    </div>

    <div class="row">
        <div class="col-md-12" id="conversations">
            <ul class="messages-list">
                <?php foreach ($messages as $message) {
                    /** @var User $user */
                    $user = $messagesData['participants'][$message->user_id]; ?>
                <li class="<?= $message->user_id == $userId ? 'mine' : 'their' ?>" data-message-id="<?= $message->id ?>">
                    <img class="avatar" src="<?= $user->getAvatarUrl() ?>">
                    <div class="message-part">
                        <span class="name"><?= $user->getFullName(true) ?></span>
                        <span class="date"><?= Formatter::datetime(Formatter::utcDatetimeToLocalDatetime($message->time, $timezone->code, 'Y-m-d H:i:s')) ?></span>
                        <p class="message"><?= $message->text ?></p>
                        <div class="clear"></div>
                    </div>
                </li>
                <?php } ?>
            </ul>
            <textarea id="new-message" name="messages-input" class="messages-input conversations-page" placeholder="Enter message here..." data-conversation-id="<?= $conversation->id ?>"></textarea>
            <a href="#" class="btn btn-success send-message">Send</a>
        </div>
    </div>

    <?php // $this->render('/layouts/_footer') ?>

</div>
<?= JsTools::viewJs($this); ?>
