<?php
use backend\models\db\Budget;
use yii\helpers\Url;
use backend\components\helpers\Formatter;

$id = isset($id) ? $id : 1;

/** @var Budget $budget */
$month = isset($month) ? $month : date('m');
$year  = isset($year) ? $year : date('Y');
?>

<table id="dp-table-<?= $id ?>" class="table table-paginated table-bordered data-table" data-table-id="dp-table-<?= $id ?>" data-ajax="<?= Url::toRoute([
    '/debt-payments/debt-transactions-table-full',
    'budget_id' => $budget->id,
    'month' => $month,
    'year' => $year
]); ?>">
    <thead>
        <tr>
            <th class="sort-by sort-desc">Date</th>
            <th>Debt</th>
            <th>Description</th>
            <th>Amount</th>
            <th>Account</th>
            <th class="no-sort"></th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td colspan="6" class="dataTables_empty">No transactions yet.</td>
        </tr>
    </tbody>
    <?php if (!isset($hideSummary) || !$hideSummary) { ?>
    <tfoot>
        <tr>
            <td colspan="5">Total Transactions</td>
            <td class="this-months-jar-debt-payments-amount">
                <?= Formatter::currency($jar->getMonthsTransactionsAmount($month, $year, false, false)) ?>
            </td>
        </tr>
    </tfoot>
    <?php } ?>
</table>
