<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
use backend\components\helpers\Formatter;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'add-debt-payment-form']); ?>
<div class="modal-body">
    <div class="message"></div>

    <?= $form->field($formModel, 'amount', [
        'inputOptions' => [
            'value' => Formatter::currency($formModel->amount, 'none')
        ]
    ]) ?>

    <?= $form->field($formModel, 'description') ?>

    <?=
    $form->field($formModel, 'formattedDate')->widget(\dosamigos\datetimepicker\DateTimePicker::className(), [
        'template' => '{input}{button}',
        'pickButtonIcon' => 'glyphicon glyphicon-calendar',
        'clientOptions' => [
            'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
            'minView' => 'month',
            'maxView' => 'year',
            'autoclose' => true
        ]
    ])->label('Date')
    ?>

    <?= $form->field($formModel, 'account_from_id')->dropDownList($accounts, [
        'prompt' => 'Select one'
    ])->label('From Account') ?>

    <?php // additional checkbox for CreditCard debts (only if there is any old debt)
    if ($debt->debt_type_id == 1 && $debt->getOldDebtLeftAmount() > 0) {
        echo $form->field($formModel, 'old_debt_payment')
            ->checkbox(['template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"])
            ->label('Apply this payment to my old debt');
    } ?>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Add Payment', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadDebtsAfterDebtPaymentAdd'), 'data-submit-url' => Url::toRoute(['/debt-payments/add-debt-payment', 'debt_id' => $debtId])]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>



