<?php
use backend\components\ActiveForm;
use backend\components\helpers\JsTools;
use backend\components\helpers\Formatter;
use yii\helpers\Html;
use yii\helpers\Url;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'add-debt-form']); ?>
<div class="modal-body">

    <div class="message"></div>

    <?= $form->field($formModel, 'name')->label('Name of Debt') ?>

    <?=
        $form->field($formModel, 'debt_type_id')
            ->dropDownList($debtTypes, ['prompt' => 'Select one'])
            ->label('Debt Type')
    ?>

    <?=
    $form->field($formModel, 'is_debt_active', [
        'options' => [
            'class' => 'form-group'
        ]
    ])->checkbox([
        'template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"
    ])->label(
        ($formModel->debt_type_id != 1 ? 'This Debt is active' : 'This Credit Card is active') . '<br/>' .
        '<em>' . ($formModel->debt_type_id != 1 ? 'A debt' : 'A credit card') .
            " is only 'Active' if it is both a debt and a source of funding to buy stuff ie an active credit card, a Line of Credit, redraw facility, etc." .
        '</em>'
    );
    ?>

    <?= $form->field($formModel, 'amount', [
        'inputOptions' => [
            'value' => Formatter::currency($formModel->amount, 'none')
        ]
    ])->label('Balance Owing') ?>

    <?=
        $form->field($formModel, 'payment', [
            'inputOptions' => [
                'value' => Formatter::currency($formModel->payment, 'none')
            ]
        ])
            ->label('Current Payment')
            ->hint('Current payment is the amount you are actually paying off your loan, this is often more than the required ‘minimum payment’. If your current payment on this loan is the minimum, just enter the minimum payment figure.')
    ?>

    <?=
        $form->field($formModel, 'frequency')
            ->dropDownList($frequencies, ['prompt' => 'Select one'])
            ->label('Payment Frequency')
    ?>

    <?=
        $form->field($formModel, 'interest')
            ->label('Interest Rate on Loan %')
            ->hint('The interest rate you are currently paying on your loan should be found on your most recent loan statement.')
    ?>

    <?=
        $form->field($formModel, 'formattedDate')->widget(\dosamigos\datetimepicker\DateTimePicker::className(), [
            'template' => '{input}{button}',
            'pickButtonIcon' => 'glyphicon glyphicon-calendar',
            'clientOptions' => [
                'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
                'minView' => 'month',
                'maxView' => 'year',
                'autoclose' => true
            ]
        ])->label('Next Payment Date')
    ?>

    <?=
        $form->field($formModel, 'account_id')->dropDownList($accounts, [
                'prompt' => 'Select one',
                'options' => [
                    $selectedAccount => ['selected'=>true]
                ]
            ])->label('Account')
            ->hint('Account is the bank account from which these loan repayments are deducted.')
    ?>

    <?=
        $form->field($formModel, 'has_interest_free_period')
            ->checkbox(['template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"])
            ->label('Has an Interest Free Period')
            ->hint('If you loan has an interest free period, tick this box and enter the date that this interest free period ends. It is very important that you keep track of this date to ensure you avoid potential heavy interest penalties when the interest period ends.')
    ?>

    <?=
    $form->field($formModel, 'formattedInterestFreeEndDate', ['options' => ['class' => 'form-group hidden']])->widget(\dosamigos\datetimepicker\DateTimePicker::className(), [
        'template' => '{input}{button}',
        'pickButtonIcon' => 'glyphicon glyphicon-calendar',
        'clientOptions' => [
            'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
            'minView' => 'month',
            'maxView' => 'year',
            'autoclose' => true
        ]
    ])->label('End of Interest Free Period')
    ?>

    <?=
        $form->field($formModel, 'tax_deductible')
            ->checkbox(['template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"])
            ->label('Is this loan tax deductible?')
            ->hint('If this loan is tax deductible check this box and Grandma’s Jars will include the interest payments in the ‘Tax deductible report’.')
    ?>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Add Debt', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadDebtsAfterAdd'), 'data-submit-url' => Url::toRoute(['/debts/add-debt', 'budget_id' => (isset($budgetId) ? $budgetId : false)])]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>


