<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Frequencies;
use backend\components\helpers\Formatter;
?>
<div role="tabpanel" class="tab-pane active" id="title1" data-js-callback="debtDetailLoaded" data-select-menu="li#my-financials-debts" data-debt-id="<?= $debt->id ?>" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
    <div class="col-head">
        <h3><?= $debt->name ?></h3>
        <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/debts/edit-debt', 'id' => $debt->id]) ?>" data-toggle="tooltip" title="Edit"><i class="glyphicon glyphicon-pencil gi-2x"></i></a>
        <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/debts/remove-debt', 'id' => $debt->id]) ?>" data-toggle="tooltip" title="Remove"><i class="glyphicon glyphicon-trash gi-2x"></i></a>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="label-group">
                <label for="frequency">Type of debt</label>
                <div class="label-value">
                    <?= $debt->getDebtType()->one()->name ?>
                </div>
            </div>
            <div class="label-group">
                <label for="payday" class="control-label">Interest rate</label>
                <div class="label-value">
                    <?= ($debt->interest) ? $debt->interest : 0; ?>%
                </div>
            </div>
            <div class="label-group">
                <label for="amount">Interest Free Cutoff Date</label>
                <div class="label-value">
                    <?= ($debt->interest_free_end_date) ? Formatter::date($debt->interest_free_end_date) : '-'; ?>
                </div>
            </div>
            <div class="label-group">
                <label for="amount">Payment Frequency</label>
                <div class="label-value">
                    <?= $debt->frequency ?>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <form>
                <div class="label-group">
                    <label for="frequency">Current Monthly Payment</label>
                    <div class="label-value">
                        <?= Formatter::currency($debt->getAverageMonthlyAmount()) ?>
                    </div>
                </div>
                <div class="label-group">
                    <label for="frequency">Minimum Monthly Payment</label>
                    <div class="label-value">
                        <?= Formatter::currency($debt->getMinimumMonthlyAmount()) ?>
                        <?php if ($debt->frequency != 'one-time') {
                            echo ($debt->frequency != 'monthly' ? '<br/>' . Formatter::currency($debt->payment) : '') .
                                ' due next on ' . Formatter::date($debt->getNextDue());
                        } ?>
                    </div>
                </div>
                <div class="label-group">
                    <label for="payday" class="control-label">Debt left</label>
                    <div class="label-value">
                        <?= Formatter::currency($debt->amount) ?>
                    </div>
                </div>
                <div class="label-group has-feedback">
                    <label for="amount">Total paid</label>
                    <div class="label-value">
                        <?= Formatter::currency($debt->getDebtPaymentsAmount()) ?>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
