<?php
use yii\helpers\Url;
use backend\components\helpers\Formatter;

$route = ['/expenses/onetime-expenses-table', 'enhanced' => (isset($enhanced) ? $enhanced : true), 'jar_id' => $jar->id, 'allow_edit' => $allowEdit];
if (isset($jsCallback)) {
    $route += ['js_callback' => $jsCallback];
}
?>

<table id="oe-table-1" class="table table-paginated table-bordered data-table" data-table-id="oe-table-1" data-ajax="<?= Url::toRoute($route) ?>">
    <thead>
        <tr>
            <th>Expense Description</th>
            <th>Amount Required</th>
            <th>Due Date</th>
            <th>Payments Left</th>
            <th>Amount I Should Have Saved Already</th>
            <th>Average Monthly Amount</th>
            <?php if ($allowEdit) { ?>
            <th class="no-sort"></th>
            <?php } ?>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td colspan="<?= $allowEdit ? 7 : 6; ?>">No expenses yet.</td>
        </tr>
    </tbody>
    <?php if (isset($totalMonthlyAvg) || isset($totalOneTimeAmount) || isset($totalOneTimeSavedAndPaid)) { ?>
    <tfoot>
        <?php if (isset($totalMonthlyAvg)) { ?>
        <tr>
            <td colspan="<?= $allowEdit ? 6 : 5; ?>">Total Average Monthly Expenses</td>
            <td class="this-montxps-averaghs-onetime-exps-average"><?= Formatter::currency($totalMonthlyAvg) ?></td>
        </tr>
        <?php } ?>
        <?php if (isset($totalOneTimeAmount)) { ?>
        <tr>
            <td colspan="<?= $allowEdit ? 6 : 5; ?>">Total One-off Expenses</td>
            <td class="total-onetime-exps-amount"><?= Formatter::currency($totalOneTimeAmount) ?></td>
        </tr>
        <?php } ?>
        <?php if (isset($totalOneTimeSavedAndPaid)) { ?>
        <tr>
            <td colspan="<?= $allowEdit ? 6 : 5; ?>">Total Saved/Paid</td>
            <td class="total-onetime-saved-paid-amount"><?= Formatter::currency($totalOneTimeSavedAndPaid) ?></td>
        </tr>
        <?php } ?>
    </tfoot>
    <?php } ?>
</table>

