<?php
use backend\components\helpers\Formatter;
use backend\widgets\Tooltip;
use yii\helpers\Url;

$route = ['/expenses/recurring-expenses-table', 'enhanced' => (isset($enhanced) ? $enhanced : true), 'jar_id' => $jar->id, 'allow_edit' => $allowEdit];
if (isset($jsCallback)) {
    $route += ['js_callback' => $jsCallback];
}
?>

<table id="re-table-1" class="table table-paginated table-bordered data-table" data-table-id="re-table-1" data-ajax="<?= Url::toRoute($route) ?>">
    <thead>
        <tr>
            <th>Expense Description</th>
            <th>Amount</th>
            <th>Expense Frequency</th>
            <th>
                Average Monthly Amount
                <?=
                    Tooltip::widget(['text' => 'The average monthly amount is the calendar monthly amount allocated to this expense ie 1/12th of the annual expense. If an expense is $100 / week the Average monthly figure would be $100 x 52 (weeks) = $5200 /12 (months) = $433.33 / month.']);
                ?>
            </th>
            <th>Due Date</th>
            <?php if ($allowEdit) { ?>
                <th class="no-sort"></th>
            <?php } ?>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td colspan="<?= $allowEdit ? 6 : 5; ?>">No expenses yet.</td>
        </tr>
    </tbody>
    <?php if (isset($totalMonthlyAvg)) { ?>
    <tfoot>
        <tr>
            <td colspan="<?= $allowEdit ? 5 : 4; ?>">Total Average Monthly Expenses</td>
            <td class="this-months-recurring-exps-average"><?= Formatter::currency($totalMonthlyAvg) ?></td>
        </tr>
    </tfoot>
    <?php } ?>
</table>

