<?php
use backend\components\ActiveForm;
use backend\components\helpers\Formatter;
use backend\components\helpers\JsTools;
use yii\helpers\Html;
use yii\helpers\Url;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'add-recurring-expense-form']); ?>
<div class="modal-body">

    <div class="message"></div>

    <?= $form->field($formModel, 'name')->label('Expense Description') ?>

    <?= $form->field($formModel, 'amount', [
        'inputOptions' => [
            'value' => Formatter::currency($formModel->amount, 'none')
        ]
    ])->label('Expense Cost') ?>

    <?=
        $form->field($formModel, 'frequency')->dropDownList($frequencies, [
            'prompt' => 'Select one'
        ])->label('Expense Frequency');
    ?>

    <?=
        $form->field($formModel, 'formattedDate')->widget(\dosamigos\datetimepicker\DateTimePicker::className(), [
            'template' => '{input}{button}',
            'pickButtonIcon' => 'glyphicon glyphicon-calendar',
            'clientOptions' => [
                'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
                'minView' => 'month',
                'maxView' => 'year',
                'autoclose' => true
            ]
        ])->label('Next Payment Date')
    ?>

    <?=
        $form->field($formModel, 'account_id')->dropDownList($accounts, [
                'prompt' => 'Select one',
                'options' => [
                    $selectedAccount => ['selected'=>true]
                ]
            ])->label('Method of Payment')
            ->hint('Selecting the method of payment will allow Grandma’s Jars to default to this payment method whenever you record this particular expense. You will be able to change the method of payment whenever you record this expense but by selecting your most common payment method you streamline the recording process.')
    ?>

    <?=
        $form->field($formModel, 'tax_deductible')
            ->checkbox(['template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"])
            ->hint('If this Expense is tax deductible check this box and Grandma’s Jars will include the Expense in the ‘Tax deductible expenses report’');
    ?>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Add Expense', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadExpenseJarRecurringExpenses'), 'data-submit-url' => Url::toRoute(['/expenses/add-recurring-expense', 'jar_id' => $jarId])]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>
