<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\widgets\FormattedTitle;
use backend\widgets\VideoTutorial;
$totalQuestions = 0;
?>
<div id="body" class="container-fluid" data-select-menu="li#support-faq" data-js-callback="supportFaqLoaded" data-page-title="<?= FormattedTitle::widget( [ 'title' => $this->title ] ); ?>">
    <?= VideoTutorial::widget() ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="col-head" id="faq_top">
                <h3><?= Html::encode( $title ) ?></h3>
            </div>
        </div>
    </div>

    <div class="row faqs">
        <div class="col-lg-12">
            <?php if (count($categories) > 0) { ?>
                <?php foreach ($categories as $catId => $c) { ?>
                <?php
                $questions = $c->getFaqQuestions()->orderBy('order asc')->all();
                $totalQuestions += count($questions);
                if (count($questions)) { ?>
                        <div class="col-head faq-col-head">
                            <h4><?= $c->name ?></h4>
                            <?php if ($c->description) { ?>
                            <p><?= Yii::$app->formatter->asNtext($c->description) ?></p>
                            <?php } ?>
                        </div>
                        <div class="faq">
                            <div class="panel">
                                <div class="panel-group" id="faq_accordion" role="tablist">
                                    <ul>
                                        <?php foreach ($questions as $qId => $q) {
                                            $faqId = 'faq_' . $catId . $qId; ?>
                                            <li>
                                                <div class="panel-heading" role="tab" id="faq_heading_<?= $catId ?>">
                                                    <h4 class="panel-title">
                                                        <a class="pageLink collapsed" href="#<?= $faqId ?>" role="button" data-toggle="collapse" data-parent="#faq_accordion" data-no-scroll="true">
                                                            <?= $q->title ?>
                                                            <i class="glyphicon glyphicon-plus pull-right closed-icon"></i>
                                                            <i class="glyphicon glyphicon-minus pull-right open-icon"></i>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="<?= $faqId ?>" class="panel-collapse collapse" role="tabpanel">
                                                    <div class="panel-body">
                                                        <?= Yii::$app->formatter->asNtext($q->description) ?>
                                                    </div>
                                                </div>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                <?php } ?>
            <?php } ?>
            <?php if ((count($categories) == 0) || !$totalQuestions) { ?>
                <p>No FAQ present at the moment.</p>
            <?php } ?>
            <p class="ask-community"><?= Html::a('Ask our wonderful community', 'https://community.grandmasjars.com/categories/faq', ['target' => '_blank']); ?></p>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>
<?php
$this->js[ 'faqs' ][] = <<<EOS
EOS;
?>
<?= \backend\components\helpers\JsTools::viewJs( $this ) ?>
