<?php
use backend\widgets\Tooltip;
use yii\helpers\Url;
?>
<div class="row">
    <div class="col-md-7">
        <div class="col-head">
            <h4>
                Regular Expenses
                <?= Tooltip::widget(['text' => 'Most expenses are ‘Regular expenses’ Regular expenses are a part of everyday life but they do not a have a set frequency or amount.']);
                ?>
            </h4>
            <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/expenses/add-estimated-expense', 'jar_id' => $jar->id, 'js_callback' => 'reloadFirstTimeSetupJars']) ?>"><i class="glyphicon glyphicon-plus"></i> Add</a>
        </div>
    </div>

    <div class="col-sm-5">
        <div class="input-group">
            <input type="text" class="form-control table-search" data-search-id="ee-table-1">
            <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-table expenses-panel recurring-expenses">
            <?= $this->render('/expenses/_estimated-expenses-table.php', [
                'jar' => $jar,
                'enhanced' => 0,
                'jsCallback' => 'reloadFirstTimeSetupJars',
                'allowEdit' => true
            ]); ?>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-7">
        <div class="col-head">
            <h4>
                Recurring Expenses
                <?=
                Tooltip::widget(['text' => 'Recurring expenses are expenses that occur at consistent interval and are the same value every time. Good examples of this are mobile phone plans, loan repayments, insurance payments, sponsor children etc. When you enter an expense as ‘Recurring’ Grandma’s Jars will automatically assume these are ongoing expenses and will record them on their due date without any input from you.']);
                ?>
            </h4>
            <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/expenses/add-recurring-expense', 'jar_id' => $jar->id, 'js_callback' => 'reloadFirstTimeSetupJars']) ?>"><i class="glyphicon glyphicon-plus"></i> Add</a>
        </div>
    </div>

    <div class="col-sm-5">
        <div class="input-group">
            <input type="text" class="form-control table-search" data-search-id="re-table-1">
            <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-table expenses-panel recurring-expenses">
            <?= $this->render('/expenses/_recurring-expenses-table.php', [
                'jar' => $jar,
                'enhanced' => 0,
                'jsCallback' => 'reloadFirstTimeSetupJars',
                'allowEdit' => true
            ]); ?>
        </div>
    </div>
</div>

<?php /*<div class="row">
    <div class="col-md-7">
        <div class="col-head">
            <h4>
                One-off Expenses
                <?=
                Tooltip::widget(['text' => 'One-off expenses are typically larger one off purchases that you are saving towards and want to factor into your budget, examples of One-off expenses are – a new laptop, a new car, an overseas holiday, wedding costs etc.']);
                ?>
            </h4>
            <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/expenses/add-onetime-expense', 'jar_id' => $jar->id, 'js_callback' => 'reloadFirstTimeSetupJars']) ?>"><i class="glyphicon glyphicon-plus"></i> Add</a>
        </div>
    </div>

    <div class="col-sm-5">
        <div class="input-group">
            <input type="text" class="form-control table-search" data-search-id="oe-table-1">
            <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-table expenses-panel onetime-expenses">
            <?= $this->render('/expenses/_onetime-expenses-table.php', [
                'jar' => $jar,
                'allowEdit' => true,
                'jsCallback' => 'reloadFirstTimeSetupJars'
            ]); ?>
        </div>
    </div>
</div>*/