<?php
use backend\components\helpers\Formatter;
?>
<?php if ($totalIncomesAmount + $totalExpensesAmount) { ?>
<div class="balance-bar<?= $expensesPctg <= 15 && $expensesPctg >= 10 || $expensesPctg >= 85 && $expensesPctg <= 90 ? ' narrow-part' : '' ?>">
    <div class="net<?= ($expensesPctg > $incomesPctg) ? ' val-minus' : ''; ?>" style="left: calc(<?= $expensesPctg > 5 ? $expensesPctg : 50 ?>% - 60px);">
        <div class="net-info">
            <div><?= (($totalIncomesAmount - $totalExpensesAmount) >= 0) ? 'Surplus' : 'Deficit'; ?></div>
            <div class="val"><?= Formatter::currency($totalIncomesAmount - $totalExpensesAmount); ?></div>
        </div>
        <div><i class="glyphicon glyphicon-triangle-bottom"></i></div>
    </div>
    <div class="debts" style="width: <?= $expensesPctg ?>%" data-toggle="tooltip" title="<?= 'Expenses ' . Formatter::currency($totalExpensesAmount) ?>">
        <?php if ($expensesPctg >= 10) { ?>
        <div class="val"><?= Formatter::currency($totalExpensesAmount) ?></div>
        <div class="text">Expenses</div>
        <?php } ?>
    </div>
    <div class="credits" style="width: <?= $incomesPctg ?>%" data-toggle="tooltip" title="<?= 'Income ' . Formatter::currency($totalIncomesAmount) ?>">
        <?php if ($incomesPctg >= 10) { ?>
        <div class="text">Income</div>
        <div class="val"><?= Formatter::currency($totalIncomesAmount) ?></div>
        <?php } ?>
    </div>
</div>
<?php } ?>
