<?php
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\components\helpers\Formatter;
use backend\components\helpers\JsTools;
?>
<div class="row">
    <div class="col-lg-12">

        <div class="col-head">
            <h3>My Debts</h3>
            <a href="#" class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/debts/add-debt', 'js_callback' => 'reloadFirstTimeSetupDebts']) ?>">Add a New Debt</a>
        </div>

        <div class="panel panel-tabbed with-balanced-bar debts-panel">
            <div class="tabpanel tabpanel-secondary">
                <div class="container-fluid">
                    <?php if (count($debts) > 0) { ?>
                    <div class="row no-gutter">
                        <div class="col-lg-6 no-float tab-col">
                            <!-- Nav tabs -->
                            <ul class="nav nav-tabs" role="tablist">
                                <?php foreach ($debts as $key => $d) { ?>
                                <li role="presentation"<?php if ($key == 0) { ?> class="active"<?php } ?> data-debt-id="<?= $d->id ?>">
                                    <a href="#debt<?= $d->id ?>" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true">
                                        <span class="clearfix">
                                            <span class="pull-left"><?= $d->name ?></span>
                                            <span class="pull-right"><?= Formatter::currency($d->amount); ?></span>
                                        </span>
                                    </a>
                                </li>
                                <?php } ?>
                            </ul>
                        </div>
                        <div class="col-lg-6 no-float">
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <?php foreach ($debts as $key => $d) { ?>
                                <div role="tabpanel" class="tab-pane<?php if ($key == 0) { ?> active<?php } ?>" id="debt<?= $d->id ?>" data-debt-id="<?= $d->id ?>">
                                    <div class="col-head">
                                        <h3><?= $d->name; ?></h3>
                                        <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/debts/edit-debt', 'id' => $d->id, 'js_callback' => 'reloadFirstTimeSetupDebts']) ?>" data-toggle="tooltip" title="Edit"><i class="glyphicon glyphicon-pencil gi-2x"></i></a>
                                        <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/debts/remove-debt', 'id' => $d->id, 'js_callback' => 'reloadFirstTimeSetupDebts']) ?>" data-toggle="tooltip" title="Remove"><i class="glyphicon glyphicon-trash gi-2x"></i></a>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-5">
                                            <div class="label-group">
                                                <label>Balance Owed</label>
                                                <span class="label-value"><?= Formatter::currency($d->amount); ?></span>
                                            </div>
                                            <div class="label-group">
                                                <label>Type of Debt</label>
                                                <span class="label-value"><?= $d->debtType->name; ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-5">
                                            <div class="label-group">
                                                <label>Current Monthly Payment</label>
                                                <span class="label-value"><?= Formatter::currency($d->getAverageMonthlyAmount()) ?></span>
                                            </div>
                                            <div class="label-group">
                                                <label>Minimum Monthly Payment</label>
                                                <span class="label-value"><?= Formatter::currency($d->getMinimumMonthlyAmount()); ?></span>
                                            </div>
                                            <div class="label-group">
                                                <label>Interest Rate</label>
                                                <span class="label-value"><?= $d->interest; ?>%</span>
                                            </div>
                                            <?php if ($d->interest_free_end_date != null) { ?>
                                            <div class="label-group">
                                                <label>End of interest free period</label>
                                                <span class="label-value"><?= Formatter::date($d->interest_free_end_date); ?></span>
                                            </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <?php } else { ?>
                    <div class="row">
                        <div class="col-lg-12 no-float">
                            <p style="padding:20px;">No debts yet.</p>
                        </div>
                    </div>
                    <?php } ?>
                </div>

                <div class="balance-bar<?= $debtsPctg <= 15 && $debtsPctg >= 10 || $debtsPctg >= 85 && $debtsPctg <= 90 ? ' narrow-part' : '' ?>">
                    <div class="net <?= $isTotalNegative ? 'val-minus' : '' ?>" style="left: calc(<?= $debtsPctg >= 5 ? $debtsPctg : 50 ?>% - 60px);">
                        <div class="net-info">
                            <div>Net Accounts</div>
                            <div class="val"><?= Formatter::currency($totalMoney); ?></div>
                        </div>
                        <div><i class="glyphicon glyphicon-triangle-bottom"></i></div>
                    </div>
                    <div class="debts" style="width: <?= $debtsPctg ?>%" data-toggle="tooltip" title="<?= 'Debt ' . Formatter::currency($totalDebtsAmount) ?>">
                        <?php if ($debtsPctg >= 10) { ?>
                        <div class="val"><?= Formatter::currency($totalDebtsAmount) ?></div>
                        <div class="text">Debt</div>
                        <?php } ?>
                    </div>
                    <div class="credits <?= $isAccountNegative ? 'is-negative' : '' ?>" style="width: <?= $accountsPctg ?>%" data-toggle="tooltip" title="<?= 'Bank Account ' . Formatter::currency($totalAccountsBalance) ?>">
                        <?php if (100 - $debtsPctg >= 10) { ?>
                        <div class="text">Bank Accounts</div>
                        <div class="val"><?= Formatter::currency($totalAccountsBalance) ?></div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
